/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.framebuffer;

import com.mojang.blaze3d.platform.GlStateManager;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFboTextureAttachment;
import net.minecraft.client.Minecraft;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL30;

@ApiStatus.Internal
public class AdvancedFboMutableTextureAttachment
extends AdvancedFboTextureAttachment {
    private int textureId;
    private int layer;

    public AdvancedFboMutableTextureAttachment(int attachmentType, int textureId, int layer) {
        super(attachmentType, 0, 0, 0, 0, 0, 0, false, null);
        this.setTexture(textureId, layer);
    }

    @Override
    public void attach(int attachment) {
        int attachmentType = this.getAttachmentType();
        Validate.isTrue((attachmentType < 36096 || attachment == 0 ? 1 : 0) != 0, (String)"Only one depth buffer attachment is supported.", (Object[])new Object[0]);
        if (Minecraft.f_91002_) {
            VeilRenderSystem.printGlErrors(null);
        }
        if (this.layer == -1) {
            GlStateManager._glFramebufferTexture2D((int)36160, (int)(attachmentType + attachment), (int)3553, (int)this.textureId, (int)0);
            if (Minecraft.f_91002_) {
                VeilRenderSystem.printGlErrors("glFramebufferTexture2D");
            }
        } else {
            GL30.glFramebufferTextureLayer((int)36160, (int)(attachmentType + attachment), (int)this.textureId, (int)0, (int)this.layer);
            if (Minecraft.f_91002_) {
                VeilRenderSystem.printGlErrors("glFramebufferTextureLayer");
            }
        }
    }

    @Override
    public void create() {
    }

    @Override
    public AdvancedFboMutableTextureAttachment clone() {
        return new AdvancedFboMutableTextureAttachment(this.textureId, this.getAttachmentType(), this.layer);
    }

    public void m_117964_() {
    }

    public int m_117963_() {
        return this.textureId;
    }

    public boolean setTexture(int textureId, int layer) {
        if (this.textureId == textureId && this.layer == layer) {
            return false;
        }
        this.textureId = textureId;
        this.layer = layer;
        return true;
    }
}

