/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import foundry.veil.mixin.accessor.BufferBuilderAccessor;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.nio.Buffer;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;

public class CachedBufferSource
implements MultiBufferSource,
NativeResource {
    private final Map<RenderType, BufferBuilder> buffers = new Object2ObjectArrayMap();
    private final Set<BufferBuilder> startedBuffers = new HashSet<BufferBuilder>();
    private Optional<RenderType> lastState = Optional.empty();

    public VertexConsumer m_6299_(RenderType renderType) {
        if (this.lastState.isPresent() && !this.lastState.get().m_234326_()) {
            this.endLastBatch();
        }
        this.lastState = renderType.m_110406_();
        BufferBuilder builder = this.buffers.computeIfAbsent(renderType, t -> new BufferBuilder(t.m_110507_()));
        if (this.startedBuffers.add(builder)) {
            builder.m_166779_(renderType.m_173186_(), renderType.m_110508_());
        }
        return builder;
    }

    public void free() {
        for (BufferBuilder value : this.buffers.values()) {
            MemoryUtil.memFree((Buffer)((BufferBuilderAccessor)value).getBuffer());
        }
        this.buffers.clear();
        this.startedBuffers.clear();
        this.lastState = Optional.empty();
    }

    public void endLastBatch() {
        this.lastState.ifPresent(this::endBatch);
        this.lastState = Optional.empty();
    }

    public void endBatch() {
        for (RenderType renderType : this.buffers.keySet()) {
            this.endBatch(renderType);
        }
    }

    public void endBatch(RenderType renderType) {
        BufferBuilder builder = this.buffers.get(renderType);
        if (builder != null && this.startedBuffers.remove(builder)) {
            renderType.m_276775_(builder, RenderSystem.getVertexSorting());
            if (Objects.equals(this.lastState, renderType.m_110406_())) {
                this.lastState = Optional.empty();
            }
        }
    }
}

