/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.lib.opencl;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct cl_bus_address_amd")
public class CLBusAddressAMD
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SURFBUSADDRESS;
    public static final int SIGNALBUSADDRESS;

    public CLBusAddressAMD(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CLBusAddressAMD.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="cl_long")
    public long surfbusaddress() {
        return CLBusAddressAMD.nsurfbusaddress(this.address());
    }

    @NativeType(value="cl_long")
    public long signalbusaddress() {
        return CLBusAddressAMD.nsignalbusaddress(this.address());
    }

    public CLBusAddressAMD surfbusaddress(@NativeType(value="cl_long") long value) {
        CLBusAddressAMD.nsurfbusaddress(this.address(), value);
        return this;
    }

    public CLBusAddressAMD signalbusaddress(@NativeType(value="cl_long") long value) {
        CLBusAddressAMD.nsignalbusaddress(this.address(), value);
        return this;
    }

    public CLBusAddressAMD set(long surfbusaddress, long signalbusaddress) {
        this.surfbusaddress(surfbusaddress);
        this.signalbusaddress(signalbusaddress);
        return this;
    }

    public CLBusAddressAMD set(CLBusAddressAMD src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CLBusAddressAMD malloc() {
        return CLBusAddressAMD.wrap(CLBusAddressAMD.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CLBusAddressAMD calloc() {
        return CLBusAddressAMD.wrap(CLBusAddressAMD.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CLBusAddressAMD create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CLBusAddressAMD.wrap(CLBusAddressAMD.class, MemoryUtil.memAddress(container), container);
    }

    public static CLBusAddressAMD create(long address) {
        return CLBusAddressAMD.wrap(CLBusAddressAMD.class, address);
    }

    @Nullable
    public static CLBusAddressAMD createSafe(long address) {
        return address == 0L ? null : CLBusAddressAMD.wrap(CLBusAddressAMD.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CLBusAddressAMD.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CLBusAddressAMD.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CLBusAddressAMD.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CLBusAddressAMD.__create(capacity, SIZEOF);
        return CLBusAddressAMD.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CLBusAddressAMD.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CLBusAddressAMD.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CLBusAddressAMD mallocStack() {
        return CLBusAddressAMD.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CLBusAddressAMD callocStack() {
        return CLBusAddressAMD.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CLBusAddressAMD mallocStack(MemoryStack stack) {
        return CLBusAddressAMD.malloc(stack);
    }

    @Deprecated
    public static CLBusAddressAMD callocStack(MemoryStack stack) {
        return CLBusAddressAMD.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CLBusAddressAMD.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CLBusAddressAMD.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CLBusAddressAMD.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CLBusAddressAMD.calloc(capacity, stack);
    }

    public static CLBusAddressAMD malloc(MemoryStack stack) {
        return CLBusAddressAMD.wrap(CLBusAddressAMD.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CLBusAddressAMD calloc(MemoryStack stack) {
        return CLBusAddressAMD.wrap(CLBusAddressAMD.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CLBusAddressAMD.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CLBusAddressAMD.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsurfbusaddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)SURFBUSADDRESS);
    }

    public static long nsignalbusaddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIGNALBUSADDRESS);
    }

    public static void nsurfbusaddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SURFBUSADDRESS, value);
    }

    public static void nsignalbusaddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIGNALBUSADDRESS, value);
    }

    static {
        Struct.Layout layout = CLBusAddressAMD.__struct(CLBusAddressAMD.__member(8), CLBusAddressAMD.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SURFBUSADDRESS = layout.offsetof(0);
        SIGNALBUSADDRESS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CLBusAddressAMD, Buffer>
    implements NativeResource {
        private static final CLBusAddressAMD ELEMENT_FACTORY = CLBusAddressAMD.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CLBusAddressAMD getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="cl_long")
        public long surfbusaddress() {
            return CLBusAddressAMD.nsurfbusaddress(this.address());
        }

        @NativeType(value="cl_long")
        public long signalbusaddress() {
            return CLBusAddressAMD.nsignalbusaddress(this.address());
        }

        public Buffer surfbusaddress(@NativeType(value="cl_long") long value) {
            CLBusAddressAMD.nsurfbusaddress(this.address(), value);
            return this;
        }

        public Buffer signalbusaddress(@NativeType(value="cl_long") long value) {
            CLBusAddressAMD.nsignalbusaddress(this.address(), value);
            return this;
        }
    }
}

