/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.pipeline;

import com.mojang.blaze3d.platform.GlStateManager;
import foundry.veil.api.client.render.shader.ShaderException;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.ARBGLSPIRV;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL41C;
import org.lwjgl.opengl.GL46C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.NativeResource;
import org.lwjgl.util.shaderc.Shaderc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@ApiStatus.Internal
public enum VeilShaderUploader {
    NONE{

        @Override
        public void compile(int shader, int type, String fileName, String source, boolean hlsl) throws ShaderException {
            if (hlsl) {
                throw new ShaderException("HLSL is unsupported on this platform");
            }
            GlStateManager.glShaderSource((int)shader, List.of(source));
        }
    }
    ,
    ARB{

        @Override
        public void compile(int shader, int type, String fileName, String source, boolean hlsl) throws ShaderException {
            try (SPIRV spirv = 2.compileSPIRV(fileName, source, type, hlsl);
                 MemoryStack stack = MemoryStack.stackPush();){
                GL41C.glShaderBinary((IntBuffer)stack.ints(shader), (int)38225, (ByteBuffer)spirv.bytecode);
                ARBGLSPIRV.glSpecializeShaderARB((int)shader, (CharSequence)"main", (IntBuffer)stack.mallocInt(0), (IntBuffer)stack.mallocInt(0));
            }
        }
    }
    ,
    CORE{

        @Override
        public void compile(int shader, int type, String fileName, String source, boolean hlsl) throws ShaderException {
            try (SPIRV spirv = 3.compileSPIRV(fileName, source, type, hlsl);
                 MemoryStack stack = MemoryStack.stackPush();){
                GL41C.glShaderBinary((IntBuffer)stack.ints(shader), (int)38225, (ByteBuffer)spirv.bytecode);
                GL46C.glSpecializeShader((int)shader, (CharSequence)"main", (IntBuffer)stack.mallocInt(0), (IntBuffer)stack.mallocInt(0));
            }
        }
    };

    private static final Int2IntMap KIND_MAP;
    private static VeilShaderUploader uploader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SPIRV compileSPIRV(String fileName, String source, int type, boolean hlsl) throws ShaderException {
        long compiler = Shaderc.shaderc_compiler_initialize();
        try {
            SPIRV sPIRV;
            if (compiler == 0L) {
                throw new ShaderException("Failed to create shader compiler");
            }
            long options = Shaderc.shaderc_compiler_initialize();
            if (options == 0L) {
                throw new ShaderException("Failed to create shader compiler");
            }
            Shaderc.shaderc_compile_options_set_source_language(options, hlsl ? 1 : 0);
            long result = Shaderc.shaderc_compile_into_spv(compiler, source, KIND_MAP.get(type), fileName, "main", options);
            try {
                if (result == 0L) {
                    throw new ShaderException("Failed to compile shader " + fileName + " into SPIR-V");
                }
                if (Shaderc.shaderc_result_get_compilation_status(result) != 0) {
                    throw new ShaderException("Failed to compile shader " + fileName + " into SPIR-V", Shaderc.shaderc_result_get_error_message(result));
                }
                sPIRV = new SPIRV(result, Shaderc.shaderc_result_get_bytes(result));
            }
            catch (Throwable throwable) {
                Shaderc.shaderc_compile_options_release(options);
                throw throwable;
            }
            Shaderc.shaderc_compile_options_release(options);
            return sPIRV;
        }
        finally {
            Shaderc.shaderc_compiler_release(compiler);
        }
    }

    public abstract void compile(int var1, int var2, String var3, String var4, boolean var5) throws ShaderException;

    public static VeilShaderUploader get() {
        if (uploader == null) {
            GLCapabilities caps = GL.getCapabilities();
            uploader = caps.OpenGL46 ? CORE : (caps.GL_ARB_gl_spirv ? ARB : NONE);
        }
        return uploader;
    }

    static {
        KIND_MAP = new Int2IntOpenHashMap();
        KIND_MAP.put(35633, 0);
        KIND_MAP.put(36488, 4);
        KIND_MAP.put(36487, 5);
        KIND_MAP.put(36313, 3);
        KIND_MAP.put(35632, 1);
        KIND_MAP.put(37305, 2);
    }

    public static final class SPIRV
    implements NativeResource {
        private final long pointer;
        private ByteBuffer bytecode;

        public SPIRV(long pointer, ByteBuffer bytecode) {
            this.pointer = pointer;
            this.bytecode = bytecode;
        }

        @Override
        public void free() {
            Shaderc.shaderc_result_release(this.pointer);
            this.bytecode = null;
        }
    }
}

