/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.client.pipeline;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.ext.VertexBufferExtension;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL31C;
import org.lwjgl.opengl.GL43C;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={VertexBuffer.class})
public abstract class VertexBufferMixin
implements VertexBufferExtension {
    @Shadow
    private VertexFormat.Mode f_166864_;
    @Shadow
    private int f_166860_;
    @Shadow
    private int f_166863_;
    @Shadow
    @Nullable
    private RenderSystem.AutoStorageIndexBuffer f_166865_;
    @Shadow
    private VertexFormat.IndexType f_166861_;

    @Shadow
    protected abstract VertexFormat.IndexType m_231231_();

    @Override
    public void veil$drawInstanced(int instances) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this._veil$drawInstanced(instances));
        } else {
            this._veil$drawInstanced(instances);
        }
    }

    @Override
    public void veil$drawIndirect(long indirect, int drawCount, int stride) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this._veil$drawIndirect(indirect, drawCount, stride));
        } else {
            this._veil$drawIndirect(indirect, drawCount, stride);
        }
    }

    @Override
    public int veil$getIndexCount() {
        return this.f_166863_;
    }

    @Inject(method={"draw"}, at={@At(value="HEAD")}, cancellable=true)
    public void drawPatches(CallbackInfo ci) {
        if (this.f_166864_ != VertexFormat.Mode.QUADS) {
            return;
        }
        ShaderProgram shader = VeilRenderSystem.getShader();
        if (shader != null && shader.hasTesselation()) {
            GL11C.glDrawArrays((int)14, (int)0, (int)(this.f_166863_ * 4 / 6));
            ci.cancel();
        }
    }

    @ModifyArg(method={"draw"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;drawElements(III)V"), index=0)
    public int modifyDrawMode(int glMode) {
        return this.veil$getDrawMode(glMode);
    }

    @Unique
    private int veil$getDrawMode(int defaultMode) {
        ShaderProgram shader = VeilRenderSystem.getShader();
        if (shader != null && shader.hasTesselation()) {
            return 14;
        }
        return defaultMode;
    }

    @Unique
    private void _veil$drawInstanced(int instances) {
        ShaderProgram shader;
        if (this.f_166864_ == VertexFormat.Mode.QUADS && (shader = VeilRenderSystem.getShader()) != null && shader.hasTesselation()) {
            GL31C.glDrawArraysInstanced((int)14, (int)0, (int)(this.f_166863_ * 4 / 6), (int)instances);
            return;
        }
        GL31C.glDrawElementsInstanced((int)this.veil$getDrawMode(this.f_166864_.f_166946_), (int)this.f_166863_, (int)this.m_231231_().f_166923_, (long)0L, (int)instances);
    }

    @Unique
    private void _veil$drawIndirect(long indirect, int drawCount, int stride) {
        if (this.f_166865_ != null) {
            this.f_166865_.m_221946_(this.f_166863_);
            GL43C.glMultiDrawElementsIndirect((int)this.veil$getDrawMode(this.f_166864_.f_166946_), (int)this.f_166865_.m_157483_().f_166923_, (long)indirect, (int)drawCount, (int)stride);
        } else {
            GL15C.glBindBuffer((int)34963, (int)this.f_166860_);
            GL43C.glMultiDrawElementsIndirect((int)this.veil$getDrawMode(this.f_166864_.f_166946_), (int)this.f_166861_.f_166923_, (long)indirect, (int)drawCount, (int)stride);
        }
    }
}

