/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.opencl;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.opencl.CLBuffer;
import foundry.veil.api.opencl.CLEnvironment;
import foundry.veil.api.opencl.CLException;
import foundry.veil.api.opencl.CLMemObject;
import foundry.veil.api.opencl.VeilOpenCL;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.IntBuffer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2fc;
import org.joml.Vector3fc;
import org.joml.Vector4fc;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL10GL;
import org.lwjgl.opengl.ARBCLEvent;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.NativeResource;

public class CLKernel
implements NativeResource {
    private final CLEnvironment environment;
    private final ResourceLocation program;
    private final long handle;
    private final int maxWorkGroupSize;
    private final LongSet pointers;
    private final boolean legacySyncGLtoCL;
    private final boolean legacySyncCLtoGL;

    CLKernel(CLEnvironment environment, ResourceLocation program, long handle) throws CLException {
        this.environment = environment;
        this.program = program;
        this.handle = handle;
        this.pointers = new LongArraySet();
        this.legacySyncGLtoCL = !environment.getDevice().capabilities().cl_khr_gl_event;
        this.legacySyncCLtoGL = !RenderSystem.isOnRenderThread() || !GL.getCapabilities().GL_ARB_cl_event;
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer work_group_loc = stack.mallocPointer(1);
            VeilOpenCL.checkCLError(CL10.clGetKernelWorkGroupInfo((long)this.handle, (long)environment.getDevice().id(), (int)4528, (PointerBuffer)work_group_loc, null));
            this.maxWorkGroupSize = (int)work_group_loc.get(0);
        }
    }

    public void execute(int globalWorkSize, int localWorkSize) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer global_work_size = stack.pointers((long)globalWorkSize);
            PointerBuffer local_work_size = stack.pointers((long)localWorkSize);
            VeilOpenCL.checkCLError(CL10.clEnqueueNDRangeKernel((long)this.environment.getCommandQueue(), (long)this.handle, (int)1, null, (PointerBuffer)global_work_size, (PointerBuffer)local_work_size, null, null));
        }
    }

    public void execute(int globalWorkSizeX, int localWorkSizeX, int globalWorkSizeY, int localWorkSizeY) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer global_work_size = stack.pointers((long)globalWorkSizeX, (long)globalWorkSizeY);
            PointerBuffer local_work_size = stack.pointers((long)localWorkSizeX, (long)localWorkSizeY);
            VeilOpenCL.checkCLError(CL10.clEnqueueNDRangeKernel((long)this.environment.getCommandQueue(), (long)this.handle, (int)2, null, (PointerBuffer)global_work_size, (PointerBuffer)local_work_size, null, null));
        }
    }

    public void execute(int globalWorkSizeX, int localWorkSizeX, int globalWorkSizeY, int localWorkSizeY, int globalWorkSizeZ, int localWorkSizeZ) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer global_work_size = stack.pointers((long)globalWorkSizeX, (long)globalWorkSizeY, (long)globalWorkSizeZ);
            PointerBuffer local_work_size = stack.pointers((long)localWorkSizeX, (long)localWorkSizeY, (long)localWorkSizeZ);
            VeilOpenCL.checkCLError(CL10.clEnqueueNDRangeKernel((long)this.environment.getCommandQueue(), (long)this.handle, (int)3, null, (PointerBuffer)global_work_size, (PointerBuffer)local_work_size, null, null));
        }
    }

    public void execute(int[] globalWorkSizes, int[] localWorkSizes) throws CLException, IllegalArgumentException {
        if (globalWorkSizes.length != localWorkSizes.length) {
            throw new IllegalArgumentException("Global work size and local work size must have the same length");
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer global_work_size = stack.mallocPointer(globalWorkSizes.length);
            for (int i = 0; i < globalWorkSizes.length; ++i) {
                global_work_size.put(i, (long)globalWorkSizes[i]);
            }
            PointerBuffer local_work_size = stack.mallocPointer(localWorkSizes.length);
            for (int i = 0; i < localWorkSizes.length; ++i) {
                local_work_size.put(i, (long)localWorkSizes[i]);
            }
            VeilOpenCL.checkCLError(CL10.clEnqueueNDRangeKernel((long)this.environment.getCommandQueue(), (long)this.handle, (int)globalWorkSizes.length, null, (PointerBuffer)global_work_size, (PointerBuffer)local_work_size, null, null));
        }
    }

    public void acquireFromGL(CLMemObject ... objects) throws CLException {
        if (!this.environment.requireManualInteropSync() || objects.length == 0) {
            return;
        }
        if (this.legacySyncGLtoCL) {
            GL11C.glFinish();
        }
        long queue = this.environment.getCommandQueue();
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pointers = stack.mallocPointer(objects.length);
            for (int i = 0; i < objects.length; ++i) {
                pointers.put(i, objects[i].pointer());
            }
            VeilOpenCL.checkCLError(CL10GL.clEnqueueAcquireGLObjects((long)queue, (PointerBuffer)pointers, null, null));
        }
    }

    public void releaseToGL(CLMemObject ... objects) throws CLException {
        if (!this.environment.requireManualInteropSync() || objects.length == 0) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pointers = stack.mallocPointer(objects.length);
            for (int i = 0; i < objects.length; ++i) {
                pointers.put(i, objects[i].pointer());
            }
            if (this.legacySyncCLtoGL) {
                VeilOpenCL.checkCLError(CL10GL.clEnqueueReleaseGLObjects((long)this.environment.getCommandQueue(), (PointerBuffer)pointers, null, null));
                this.environment.finish();
                return;
            }
            PointerBuffer syncBuffer = stack.mallocPointer(1);
            VeilOpenCL.checkCLError(CL10GL.clEnqueueReleaseGLObjects((long)this.environment.getCommandQueue(), (PointerBuffer)pointers, null, (PointerBuffer)syncBuffer));
            long event = syncBuffer.get(0);
            long glFenceFromCLEvent = ARBCLEvent.glCreateSyncFromCLeventARB((long)this.environment.getContext(), (long)event, (int)0);
            GL32C.glWaitSync((long)glFenceFromCLEvent, (int)0, (long)0L);
            GL32C.glDeleteSync((long)glFenceFromCLEvent);
            VeilOpenCL.checkCLError(CL10.clReleaseEvent((long)event));
        }
    }

    @Nullable
    public CLBuffer createBufferUnsafe(int flags, long size) {
        try {
            return this.createBuffer(flags, size);
        }
        catch (CLException e) {
            VeilOpenCL.LOGGER.error("Failed to create CL buffer", (Throwable)e);
            return null;
        }
    }

    public CLBuffer createBuffer(int flags, long size) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer error_ret = stack.mallocInt(1);
            long pointer = CL10.clCreateBuffer((long)this.environment.getContext(), (long)flags, (long)size, (IntBuffer)error_ret);
            VeilOpenCL.checkCLError(error_ret.get(0));
            this.pointers.add(pointer);
            CLBuffer cLBuffer = new CLBuffer(this, pointer);
            return cLBuffer;
        }
    }

    @Nullable
    public CLBuffer createBufferFromGLUnsafe(int flags, int buffer) {
        try {
            return this.createBufferFromGL(flags, buffer);
        }
        catch (CLException e) {
            VeilOpenCL.LOGGER.error("Failed to create CL buffer", (Throwable)e);
            return null;
        }
    }

    public CLBuffer createBufferFromGL(int flags, int buffer) throws CLException {
        if (this.environment.isOpenGLSupported() && !this.environment.requireManualInteropSync()) {
            RenderSystem.assertOnRenderThread();
            GL11C.glFinish();
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer error_ret = stack.mallocInt(1);
            long pointer = CL10GL.clCreateFromGLBuffer((long)this.environment.getContext(), (long)flags, (int)buffer, (IntBuffer)error_ret);
            VeilOpenCL.checkCLError(error_ret.get(0));
            this.pointers.add(pointer);
            CLBuffer cLBuffer = new CLBuffer(this, pointer);
            return cLBuffer;
        }
    }

    public void setByte(int index, byte value) throws CLException {
        VeilOpenCL.checkCLError(CL10.clSetKernelArg1b((long)this.handle, (int)index, (byte)value));
    }

    public void setShort(int index, short value) throws CLException {
        VeilOpenCL.checkCLError(CL10.clSetKernelArg1s((long)this.handle, (int)index, (short)value));
    }

    public void setInt(int index, int value) throws CLException {
        VeilOpenCL.checkCLError(CL10.clSetKernelArg1i((long)this.handle, (int)index, (int)value));
    }

    public void setLong(int index, long value) throws CLException {
        VeilOpenCL.checkCLError(CL10.clSetKernelArg1l((long)this.handle, (int)index, (long)value));
    }

    public void setFloat(int index, float value) throws CLException {
        VeilOpenCL.checkCLError(CL10.clSetKernelArg1f((long)this.handle, (int)index, (float)value));
    }

    public void setVector2f(int index, Vector2fc value) throws CLException {
        this.setVector2f(index, value.x(), value.y());
    }

    public void setVector2f(int index, float x, float y) throws CLException {
        VeilOpenCL.checkCLError(CL10.clSetKernelArg2f((long)this.handle, (int)index, (float)x, (float)y));
    }

    public void setVector3f(int index, Vector3fc value) throws CLException {
        this.setVector4f(index, value.x(), value.y(), value.z(), 0.0f);
    }

    public void setVector4f(int index, Vector4fc value) throws CLException {
        this.setVector4f(index, value.x(), value.y(), value.z(), value.z());
    }

    public void setVector4f(int index, float x, float y, float z, float w) throws CLException {
        VeilOpenCL.checkCLError(CL10.clSetKernelArg4f((long)this.handle, (int)index, (float)x, (float)y, (float)z, (float)w));
    }

    public void setDouble(int index, double value) throws CLException {
        VeilOpenCL.checkCLError(CL10.clSetKernelArg1d((long)this.handle, (int)index, (double)value));
    }

    public void setPointers(int index, long ... value) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer arg_value = stack.pointers(value);
            VeilOpenCL.checkCLError(CL10.clSetKernelArg((long)this.handle, (int)index, (PointerBuffer)arg_value));
        }
    }

    public void setPointers(int index, CLMemObject ... value) throws CLException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer arg_value = stack.mallocPointer(value.length);
            for (CLMemObject object : value) {
                arg_value.put(object.pointer());
            }
            arg_value.rewind();
            VeilOpenCL.checkCLError(CL10.clSetKernelArg((long)this.handle, (int)index, (PointerBuffer)arg_value));
        }
    }

    public CLEnvironment getEnvironment() {
        return this.environment;
    }

    public ResourceLocation getProgram() {
        return this.program;
    }

    public long getHandle() {
        return this.handle;
    }

    public int getMaxWorkGroupSize() {
        return this.maxWorkGroupSize;
    }

    public void free() {
        CL10.clReleaseKernel((long)this.handle);
        this.pointers.forEach(CL10::clReleaseMemObject);
        this.pointers.clear();
        this.environment.free(this);
    }

    @ApiStatus.Internal
    void free(CLMemObject object) {
        long pointer = object.pointer();
        this.pointers.remove(pointer);
        CL10.clReleaseMemObject((long)pointer);
    }
}

