/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.definition;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.definition.DynamicShaderBlock;
import foundry.veil.impl.client.render.shader.definition.ShaderBlockImpl;
import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.system.MemoryStack;

@ApiStatus.Internal
public class DynamicShaderBlockImpl<T>
extends ShaderBlockImpl<T>
implements DynamicShaderBlock<T> {
    protected final BiConsumer<T, ByteBuffer> serializer;
    private long size;
    private boolean resized;

    public DynamicShaderBlockImpl(int binding, long size, @NotNull BiConsumer<T, ByteBuffer> serializer) {
        super(binding);
        this.serializer = serializer;
        this.size = size;
        this.resized = false;
    }

    @Override
    public void setSize(long size) {
        this.size = size;
        this.resized = true;
    }

    @Override
    public void bind(int index) {
        Validate.inclusiveBetween((long)0L, (long)VeilRenderSystem.maxTargetBindings(this.binding), (long)index);
        if (this.buffer == 0) {
            this.buffer = GL15C.glGenBuffers();
            this.resized = true;
        }
        if (this.resized) {
            this.resized = false;
            this.dirty = true;
            GL15C.glBindBuffer((int)this.binding, (int)this.buffer);
            GL15C.glBufferData((int)this.binding, (long)this.size, (int)35048);
            GL15C.glBindBuffer((int)this.binding, (int)0);
        }
        if (this.dirty) {
            this.dirty = false;
            GL15C.glBindBuffer((int)this.binding, (int)this.buffer);
            try (MemoryStack stack = MemoryStack.stackPush();){
                if (this.value != null) {
                    ByteBuffer buffer = stack.malloc((int)this.size);
                    this.serializer.accept(this.value, buffer);
                    buffer.rewind();
                    GL15C.glBufferSubData((int)this.binding, (long)0L, (ByteBuffer)buffer);
                } else {
                    GL15C.glBufferSubData((int)this.binding, (long)0L, (ByteBuffer)stack.calloc((int)this.size));
                }
            }
            GL15C.glBindBuffer((int)this.binding, (int)0);
        }
        GL30C.glBindBufferBase((int)this.binding, (int)index, (int)this.buffer);
    }

    @Override
    public void unbind(int index) {
        Validate.inclusiveBetween((long)0L, (long)VeilRenderSystem.maxTargetBindings(this.binding), (long)index);
        GL30C.glBindBufferBase((int)this.binding, (int)index, (int)0);
    }
}

