/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.program;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.AdvancedFboTextureAttachment;
import foundry.veil.api.client.render.shader.texture.ShaderTextureSource;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.jetbrains.annotations.Nullable;

public interface TextureUniformAccess {
    default public void addRenderSystemTextures() {
        for (int i = 0; i < 12; ++i) {
            this.addSampler("Sampler" + i, RenderSystem.getShaderTexture((int)i));
        }
    }

    default public void setFramebufferSamplers(AdvancedFbo framebuffer) {
        boolean setDiffuseSampler = false;
        for (int i = 0; i < framebuffer.getColorAttachments(); ++i) {
            if (!framebuffer.isColorTextureAttachment(i)) continue;
            AdvancedFboTextureAttachment attachment = framebuffer.getColorTextureAttachment(i);
            this.addSampler("DiffuseSampler" + i, attachment.m_117963_());
            if (attachment.getName() != null) {
                this.addSampler(attachment.getName(), attachment.m_117963_());
            }
            if (setDiffuseSampler) continue;
            this.addSampler("DiffuseSampler", attachment.m_117963_());
            setDiffuseSampler = true;
        }
        if (framebuffer.isDepthTextureAttachment()) {
            AdvancedFboTextureAttachment attachment = framebuffer.getDepthTextureAttachment();
            this.addSampler("DiffuseDepthSampler", attachment.m_117963_());
            if (attachment.getName() != null) {
                this.addSampler(attachment.getName(), attachment.m_117963_());
            }
        }
    }

    public void addSamplerListener(SamplerListener var1);

    public void removeSamplerListener(SamplerListener var1);

    public void addSampler(CharSequence var1, int var2);

    public void removeSampler(CharSequence var1);

    default public int applyShaderSamplers(int sampler) {
        return this.applyShaderSamplers(ShaderTextureSource.GLOBAL_CONTEXT, sampler);
    }

    public int applyShaderSamplers(@Nullable ShaderTextureSource.Context var1, int var2);

    public void clearSamplers();

    @FunctionalInterface
    public static interface SamplerListener {
        public void onUpdateSamplers(Object2IntMap<CharSequence> var1);
    }
}

