/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.tooltip;

import foundry.veil.api.client.color.Color;
import foundry.veil.api.client.color.ColorTheme;
import foundry.veil.api.client.tooltip.Tooltippable;
import foundry.veil.api.client.tooltip.VeilUIItemTooltipDataHolder;
import foundry.veil.api.client.tooltip.anim.TooltipTimeline;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockEntity.class})
public class BlockEntityMixin
implements Tooltippable {
    @Unique
    private List<Component> veil$tooltip = new ArrayList<Component>();
    @Unique
    private ColorTheme veil$theme;
    @Unique
    private List<VeilUIItemTooltipDataHolder> veil$tooltipDataHolder = new ArrayList<VeilUIItemTooltipDataHolder>();
    @Unique
    private TooltipTimeline veil$timeline = null;
    @Unique
    private boolean veil$worldspace = true;
    @Unique
    private boolean veil$tooltipEnabled = false;
    @Unique
    private int veil$tooltipX = 0;
    @Unique
    private int veil$tooltipY = 0;
    @Unique
    private int veil$tooltipWidth = 0;
    @Unique
    private int veil$tooltipHeight = 0;

    @Override
    public List<Component> getTooltip() {
        return this.veil$tooltip;
    }

    @Override
    public boolean isTooltipEnabled() {
        return this.veil$tooltipEnabled;
    }

    @Override
    public CompoundTag saveTooltipData() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("tooltipEnabled", this.veil$tooltipEnabled);
        tag.m_128405_("tooltipX", this.veil$tooltipX);
        tag.m_128405_("tooltipY", this.veil$tooltipY);
        tag.m_128405_("tooltipWidth", this.veil$tooltipWidth);
        tag.m_128405_("tooltipHeight", this.veil$tooltipHeight);
        tag.m_128379_("worldspace", this.veil$worldspace);
        if (this.veil$theme != null) {
            CompoundTag themeTag = new CompoundTag();
            for (Map.Entry<String, Color> entry : this.veil$theme.getColorsMap().entrySet()) {
                String key = entry.getKey() != null ? entry.getKey() : "";
                themeTag.m_128405_(key, entry.getValue().getRGB());
            }
            tag.m_128365_("theme", (Tag)themeTag);
        }
        return tag;
    }

    @Override
    public void loadTooltipData(CompoundTag tag) {
        this.veil$tooltipEnabled = tag.m_128471_("tooltipEnabled");
        this.veil$tooltipX = tag.m_128451_("tooltipX");
        this.veil$tooltipY = tag.m_128451_("tooltipY");
        this.veil$tooltipWidth = tag.m_128451_("tooltipWidth");
        this.veil$tooltipHeight = tag.m_128451_("tooltipHeight");
        this.veil$worldspace = tag.m_128471_("worldspace");
        if (this.veil$theme != null) {
            this.veil$theme.clear();
        }
        if (tag.m_128425_("theme", 10)) {
            if (this.veil$theme == null) {
                this.veil$theme = new ColorTheme();
            }
            CompoundTag themeTag = tag.m_128469_("theme");
            for (String key : themeTag.m_128431_()) {
                this.veil$theme.addColor(key, Color.of(themeTag.m_128451_(key)));
            }
        }
    }

    @Override
    public void setTooltip(List<Component> tooltip) {
        this.veil$tooltip = tooltip;
    }

    @Override
    public void addTooltip(Component tooltip) {
        this.veil$tooltip.add(tooltip);
    }

    @Override
    public void addTooltip(List<Component> tooltip) {
        this.veil$tooltip.addAll(tooltip);
    }

    @Override
    public void addTooltip(String tooltip) {
        this.veil$tooltip.add(Component.m_130674_((String)tooltip));
    }

    @Override
    public ColorTheme getTheme() {
        return this.veil$theme;
    }

    @Override
    public void setTheme(ColorTheme theme) {
        this.veil$theme = theme;
    }

    @Override
    public void setBackgroundColor(int color) {
        this.veil$theme.addColor("background", Color.of(color));
    }

    @Override
    public void setTopBorderColor(int color) {
        this.veil$theme.addColor("topBorder", Color.of(color));
    }

    @Override
    public void setBottomBorderColor(int color) {
        this.veil$theme.addColor("bottomBorder", Color.of(color));
    }

    @Override
    public boolean getWorldspace() {
        return this.veil$worldspace;
    }

    @Override
    public TooltipTimeline getTimeline() {
        return this.veil$timeline;
    }

    @Override
    public ItemStack getStack() {
        return ItemStack.f_41583_;
    }

    @Override
    public int getTooltipWidth() {
        return this.veil$tooltipWidth;
    }

    @Override
    public int getTooltipHeight() {
        return this.veil$tooltipHeight;
    }

    @Override
    public int getTooltipXOffset() {
        return this.veil$tooltipX;
    }

    @Override
    public int getTooltipYOffset() {
        return this.veil$tooltipHeight;
    }

    @Override
    public List<VeilUIItemTooltipDataHolder> getItems() {
        return this.veil$tooltipDataHolder;
    }

    @Inject(method={"saveAdditional"}, at={@At(value="RETURN")})
    public void saveAdditional(CompoundTag $$0, CallbackInfo ci) {
        $$0.m_128365_("tooltipData", (Tag)this.saveTooltipData());
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    public void loadAdditional(CompoundTag $$0, CallbackInfo ci) {
        this.loadTooltipData($$0.m_128469_("tooltipData"));
    }
}

