/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.glsl;

import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class GlslSyntaxException
extends Exception {
    public static final int CONTEXT_AMOUNT = 64;
    private final String message;
    private final String input;
    private final int cursor;

    public GlslSyntaxException(String message, String input, int cursor) {
        super(message);
        this.message = message;
        this.input = input;
        this.cursor = cursor;
    }

    @Override
    public String getMessage() {
        Object message = this.message;
        String context = this.getContext();
        if (context != null) {
            message = (String)message + " at position " + this.cursor + ": " + context;
        }
        return message;
    }

    private String getContext() {
        if (this.input == null || this.cursor < 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int cursor = Math.min(this.input.length(), this.cursor);
        if (cursor > 64) {
            builder.append("...");
        }
        builder.append(this.input, Math.max(0, cursor - 64), cursor);
        builder.append("<--[HERE]");
        return builder.toString();
    }
}

