/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.pipeline;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.definition.ShaderBlock;
import foundry.veil.impl.client.render.shader.definition.ShaderBlockImpl;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class VeilUniformBlockState {
    private final Object2IntMap<ShaderBlockImpl<?>> boundBlocks = new Object2IntArrayMap();
    private final Int2ObjectMap<CharSequence> shaderBindings = new Int2ObjectArrayMap();
    private final IntSet usedBindings = new IntOpenHashSet();
    private int nextBinding;

    private void freeBinding() {
        ObjectIterator iterator = this.boundBlocks.object2IntEntrySet().iterator();
        while (iterator.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
            int binding = entry.getIntValue();
            if (this.usedBindings.contains(binding)) continue;
            this.unbind(binding, (ShaderBlockImpl)entry.getKey());
            iterator.remove();
            this.nextBinding = binding;
            return;
        }
        throw new IllegalStateException("Too many shader blocks bound, failed to find empty space.");
    }

    public int bind(ShaderBlock<?> block) {
        if (!(block instanceof ShaderBlockImpl)) {
            throw new UnsupportedOperationException("Cannot bind " + block.getClass());
        }
        ShaderBlockImpl impl = (ShaderBlockImpl)block;
        int binding = this.boundBlocks.getOrDefault(block, -1);
        if (binding == -1) {
            if (this.nextBinding >= VeilRenderSystem.maxUniformBuffersBindings()) {
                this.freeBinding();
            }
            binding = this.nextBinding;
            this.boundBlocks.put((Object)impl, binding);
            while (this.boundBlocks.containsValue(this.nextBinding)) {
                ++this.nextBinding;
            }
        }
        impl.bind(binding);
        this.usedBindings.add(binding);
        return binding;
    }

    public void bind(CharSequence name, ShaderBlock<?> block) {
        if (!(block instanceof ShaderBlockImpl)) {
            throw new UnsupportedOperationException("Cannot bind " + block.getClass());
        }
        ShaderBlockImpl impl = (ShaderBlockImpl)block;
        int binding = this.bind(block);
        CharSequence boundName = (CharSequence)this.shaderBindings.get(binding);
        if (!Objects.equals(name, boundName)) {
            this.shaderBindings.put(binding, (Object)name);
            VeilRenderSystem.renderer().getShaderManager().setGlobal(shader -> {
                switch (impl.getBinding()) {
                    case 35345: {
                        shader.setUniformBlock(name, binding);
                        break;
                    }
                    case 37074: {
                        shader.setStorageBlock(name, binding);
                    }
                }
            });
        }
    }

    public void unbind(ShaderBlock<?> block) {
        if (!(block instanceof ShaderBlockImpl)) {
            throw new UnsupportedOperationException("Cannot unbind " + block.getClass());
        }
        ShaderBlockImpl impl = (ShaderBlockImpl)block;
        if (this.boundBlocks.containsKey(block)) {
            this.unbind(this.boundBlocks.removeInt(block), impl);
        }
    }

    private void unbind(int binding, ShaderBlockImpl<?> block) {
        block.unbind(binding);
        CharSequence name = (CharSequence)this.shaderBindings.remove(binding);
        if (name != null) {
            VeilRenderSystem.renderer().getShaderManager().setGlobal(shader -> {
                switch (block.getBinding()) {
                    case 35345: {
                        shader.setUniformBlock(name, 0);
                        break;
                    }
                    case 37074: {
                        shader.setStorageBlock(name, 0);
                    }
                }
            });
        }
        if (binding < this.nextBinding) {
            this.nextBinding = binding;
        }
    }

    public void queueUpload() {
        this.shaderBindings.clear();
    }

    public void clear() {
        this.usedBindings.clear();
    }
}

