/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.pipeline;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

@ApiStatus.Internal
public class PostPipelineContext
implements PostPipeline.Context,
NativeResource {
    private final VertexBuffer vbo = new VertexBuffer(VertexBuffer.Usage.STATIC);
    private final Map<CharSequence, Integer> samplers = new HashMap<CharSequence, Integer>();
    private final Map<ResourceLocation, AdvancedFbo> framebuffers = new HashMap<ResourceLocation, AdvancedFbo>();

    public PostPipelineContext() {
        this.setupScreenQuad();
    }

    private void setupScreenQuad() {
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85814_);
        bufferBuilder.m_5483_(-1.0, 1.0, 0.0).m_5752_();
        bufferBuilder.m_5483_(-1.0, -1.0, 0.0).m_5752_();
        bufferBuilder.m_5483_(1.0, 1.0, 0.0).m_5752_();
        bufferBuilder.m_5483_(1.0, -1.0, 0.0).m_5752_();
        this.vbo.m_85921_();
        this.vbo.m_231221_(bufferBuilder.m_231175_());
        VertexBuffer.m_85931_();
    }

    public void begin() {
        VeilRenderSystem.renderer().getFramebufferManager().getFramebuffers().forEach(this::setFramebuffer);
        this.setFramebuffer(VeilFramebuffers.POST, this.getDrawFramebuffer());
    }

    public void end() {
        this.samplers.clear();
        this.framebuffers.clear();
    }

    @Override
    public void drawScreenQuad() {
        this.vbo.m_85921_();
        this.vbo.m_166882_();
        VertexBuffer.m_85931_();
    }

    @Override
    public void setSampler(CharSequence name, int id) {
        this.samplers.put(name, id);
    }

    @Override
    public void setFramebuffer(ResourceLocation name, AdvancedFbo framebuffer) {
        this.framebuffers.put(name, framebuffer);
    }

    @Override
    public void applySamplers(ShaderProgram shader) {
        this.samplers.forEach(shader::addSampler);
    }

    @Override
    @Nullable
    public AdvancedFbo getFramebuffer(ResourceLocation name) {
        return this.framebuffers.get(name);
    }

    @Override
    public AdvancedFbo getDrawFramebuffer() {
        return this.framebuffers.getOrDefault(VeilFramebuffers.POST, AdvancedFbo.getMainFramebuffer());
    }

    public void free() {
        this.vbo.close();
    }
}

