/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.processor;

import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.commons.io.IOUtils;

public class ShaderImportProcessor
implements ShaderPreProcessor {
    private static final String INCLUDE_KEY = "#include ";
    private final ResourceProvider resourceProvider;
    private final Set<ResourceLocation> addedImports;
    private final Map<ResourceLocation, String> imports;
    private final List<ResourceLocation> importOrder;
    private int layer;

    public ShaderImportProcessor(ResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
        this.addedImports = new HashSet<ResourceLocation>();
        this.imports = new HashMap<ResourceLocation, String>();
        this.importOrder = new ArrayList<ResourceLocation>();
        this.layer = 0;
    }

    @Override
    public void prepare() {
        this.addedImports.clear();
    }

    @Override
    public String modify(ShaderPreProcessor.Context context, String source) throws IOException {
        List<String> inputLines = source.lines().toList();
        LinkedList<String> output = new LinkedList<String>();
        for (String line : inputLines) {
            if (!line.startsWith(INCLUDE_KEY)) {
                output.add(line);
                continue;
            }
            try {
                String trimmedImport = line.substring(INCLUDE_KEY.length()).trim();
                ResourceLocation include = new ResourceLocation(trimmedImport);
                context.addInclude(include);
                if (!this.addedImports.add(include)) continue;
                try {
                    String importString;
                    if (!this.imports.containsKey(include)) {
                        this.imports.put(include, this.loadImport(include));
                        this.importOrder.add(include);
                    }
                    if ((importString = this.imports.get(include)) == null) {
                        throw new IOException("Import previously failed to load");
                    }
                    long lineNumber = String.join((CharSequence)"\n", output).lines().count();
                    int sourceNumber = this.importOrder.indexOf(include) + 1;
                    ++this.layer;
                    output.add(context.modify(include, importString));
                    --this.layer;
                }
                catch (Exception e) {
                    throw new IOException("Failed to add import: " + line, e);
                }
            }
            catch (ResourceLocationException e) {
                throw new IOException("Invalid import: " + line, e);
            }
        }
        return String.join((CharSequence)"\n", output);
    }

    private String loadImport(ResourceLocation source) throws IOException {
        Resource resource = this.resourceProvider.m_215593_(ShaderManager.INCLUDE_LISTER.m_245698_(source));
        try (BufferedReader reader = resource.m_215508_();){
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
    }
}

