/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.necromancer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.Veil;
import foundry.veil.api.client.necromancer.Skeleton;
import foundry.veil.api.client.necromancer.SkinnedMesh;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilVertexFormat;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class Skin {
    final Map<Integer, SkinnedMesh> boneToMesh = new HashMap<Integer, SkinnedMesh>();
    final ResourceLocation shader;
    final ResourceLocation texture;
    VertexBuffer mesh = null;

    private Skin(ResourceLocation shader, ResourceLocation texture) {
        this.shader = shader;
        this.texture = texture;
    }

    private void build() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        VeilRenderSystem.setShader(this.shader);
        this.mesh = new VertexBuffer(VertexBuffer.Usage.STATIC);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, VeilVertexFormat.SKINNED_MESH);
        for (Map.Entry<Integer, SkinnedMesh> meshEntry : this.boneToMesh.entrySet()) {
            meshEntry.getValue().build(bufferbuilder, meshEntry.getKey());
        }
        BufferBuilder.RenderedBuffer renderedBuffer = bufferbuilder.m_231175_();
        this.mesh.m_85921_();
        this.mesh.m_231221_(renderedBuffer);
        VertexBuffer.m_85931_();
    }

    public void render(PoseStack stack, Skeleton skeleton) {
        this.mesh.m_253207_(stack.m_85850_().m_252922_(), RenderSystem.getProjectionMatrix(), VeilRenderSystem.setShader(this.shader).toShaderInstance());
    }

    public static class Builder {
        private final Skeleton skeleton;
        private final Skin skin;

        public Builder(Skeleton skeleton, ResourceLocation shader, ResourceLocation texture) {
            this.skeleton = skeleton;
            this.skin = new Skin(shader, texture);
        }

        public Builder assignMesh(String boneName, SkinnedMesh mesh) {
            if (!this.skeleton.nameToId.containsKey(boneName)) {
                Veil.LOGGER.error("Cannot find bone of name {} in skeleton! Mesh not assigned.", (Object)boneName);
            } else {
                this.skin.boneToMesh.put(this.skeleton.nameToId.get(boneName), mesh);
            }
            return this;
        }

        public Skin build() {
            return this.skin;
        }
    }
}

