/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_preprocessor;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.github.douira.glsl_preprocessor.LexerException;
import io.github.douira.glsl_preprocessor.Macro;
import io.github.douira.glsl_preprocessor.Preprocessor;
import io.github.douira.glsl_preprocessor.PreprocessorListener;
import io.github.douira.glsl_preprocessor.SourceIterator;
import io.github.douira.glsl_preprocessor.Token;
import io.github.douira.glsl_preprocessor.Warning;
import java.io.Closeable;
import java.util.Iterator;

public abstract class Source
implements Iterable<Token>,
Closeable {
    private Source parent = null;
    private boolean autopop = false;
    private PreprocessorListener listener = null;
    private boolean active = true;
    private boolean werror = false;

    void setParent(Source parent, boolean autopop) {
        this.parent = parent;
        this.autopop = autopop;
    }

    final Source getParent() {
        return this.parent;
    }

    void init(Preprocessor pp) {
        this.setListener(pp.getListener());
        this.werror = pp.getWarnings().contains((Object)Warning.ERROR);
    }

    public void setListener(PreprocessorListener pl) {
        this.listener = pl;
    }

    @CheckForNull
    public String getPath() {
        Source parent = this.getParent();
        if (parent != null) {
            return parent.getPath();
        }
        return null;
    }

    @CheckForNull
    public String getName() {
        Source parent = this.getParent();
        if (parent != null) {
            return parent.getName();
        }
        return null;
    }

    public int getLine() {
        Source parent = this.getParent();
        if (parent == null) {
            return 0;
        }
        return parent.getLine();
    }

    public int getColumn() {
        Source parent = this.getParent();
        if (parent == null) {
            return 0;
        }
        return parent.getColumn();
    }

    boolean isExpanding(@NonNull Macro m) {
        Source parent = this.getParent();
        if (parent != null) {
            return parent.isExpanding(m);
        }
        return false;
    }

    boolean isAutopop() {
        return this.autopop;
    }

    boolean isNumbered() {
        return false;
    }

    void setActive(boolean b) {
        this.active = b;
    }

    boolean isActive() {
        return this.active;
    }

    @NonNull
    public abstract Token token();

    @Override
    public Iterator<Token> iterator() {
        return new SourceIterator(this);
    }

    @NonNull
    public Token skipline(boolean white) {
        block5: while (true) {
            Token tok = this.token();
            switch (tok.getType()) {
                case 265: {
                    this.warning(tok.getLine(), tok.getColumn(), "No newline before end of file");
                    return new Token(284, tok.getLine(), tok.getColumn(), "\n");
                }
                case 284: {
                    return tok;
                }
                case 260: 
                case 261: 
                case 294: {
                    continue block5;
                }
            }
            if (!white) continue;
            this.warning(tok.getLine(), tok.getColumn(), "Unexpected nonwhite token");
        }
    }

    protected void error(int line, int column, String msg) {
        if (this.listener == null) {
            throw new LexerException("Error at " + line + ":" + column + ": " + msg);
        }
        this.listener.handleError(this, line, column, msg);
    }

    protected void warning(int line, int column, String msg) {
        if (this.werror) {
            this.error(line, column, msg);
        } else if (this.listener != null) {
            this.listener.handleWarning(this, line, column, msg);
        } else {
            throw new LexerException("Warning at " + line + ":" + column + ": " + msg);
        }
    }

    @Override
    public void close() {
    }
}

