/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_preprocessor;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.github.douira.glsl_preprocessor.Argument;
import io.github.douira.glsl_preprocessor.Macro;
import io.github.douira.glsl_preprocessor.Source;
import io.github.douira.glsl_preprocessor.SourceIterator;
import io.github.douira.glsl_preprocessor.StringLexerSource;
import io.github.douira.glsl_preprocessor.Token;
import java.util.Iterator;
import java.util.List;

class MacroTokenSource
extends Source {
    private final Macro macro;
    private final Iterator<Token> tokens;
    private final List<Argument> args;
    private Iterator<Token> arg;

    MacroTokenSource(@NonNull Macro m, @NonNull List<Argument> args) {
        this.macro = m;
        this.tokens = m.getTokens().iterator();
        this.args = args;
        this.arg = null;
    }

    @Override
    boolean isExpanding(@NonNull Macro m) {
        if (this.macro == m) {
            return true;
        }
        return super.isExpanding(m);
    }

    static void escape(@NonNull StringBuilder buf, @NonNull CharSequence cs) {
        if (buf == null) {
            throw new NullPointerException("Buffer was null.");
        }
        if (cs == null) {
            throw new NullPointerException("CharSequence was null.");
        }
        block6: for (int i = 0; i < cs.length(); ++i) {
            char c = cs.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\\\");
                    continue block6;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block6;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block6;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block6;
                }
                default: {
                    buf.append(c);
                }
            }
        }
    }

    private void concat(@NonNull StringBuilder buf, @NonNull Argument arg) {
        for (Token tok : arg) {
            buf.append(tok.getText());
        }
    }

    @NonNull
    private Token stringify(@NonNull Token pos, @NonNull Argument arg) {
        StringBuilder buf = new StringBuilder();
        this.concat(buf, arg);
        StringBuilder str = new StringBuilder("\"");
        MacroTokenSource.escape(str, buf);
        str.append("\"");
        return new Token(292, pos.getLine(), pos.getColumn(), str.toString(), buf.toString());
    }

    private boolean isVariadicArgument(int argumentIndex) {
        if (!this.macro.isVariadic()) {
            return false;
        }
        return argumentIndex == this.args.size() - 1;
    }

    private void paste(@NonNull Token ptok) {
        StringBuilder buf = new StringBuilder();
        int count = 2;
        boolean comma = false;
        block6: for (int i = 0; i < count; ++i) {
            if (!this.tokens.hasNext()) {
                this.error(ptok.getLine(), ptok.getColumn(), "Paste at end of expansion");
                buf.append(' ').append(ptok.getText());
                break;
            }
            Token tok = this.tokens.next();
            switch (tok.getType()) {
                case 297: {
                    count += 2;
                    ptok = tok;
                    break;
                }
                case 296: {
                    int idx = (Integer)tok.getValue();
                    Argument arg = this.args.get(idx);
                    if (comma && this.isVariadicArgument(idx) && arg.isEmpty()) {
                        buf.setLength(buf.length() - 1);
                        break;
                    }
                    this.concat(buf, arg);
                    break;
                }
                case 260: 
                case 261: {
                    break;
                }
                case 44: {
                    comma = true;
                    buf.append(tok.getText());
                    continue block6;
                }
                default: {
                    buf.append(tok.getText());
                }
            }
            comma = false;
        }
        StringLexerSource sl = new StringLexerSource(buf.toString());
        this.arg = new SourceIterator(sl);
    }

    @Override
    public Token token() {
        Token tok;
        block5: while (true) {
            if (this.arg != null) {
                if (this.arg.hasNext()) {
                    tok = this.arg.next();
                    assert (tok.getType() != 297) : "Unexpected paste token";
                    return tok;
                }
                this.arg = null;
            }
            if (!this.tokens.hasNext()) {
                return new Token(265, -1, -1, "");
            }
            tok = this.tokens.next();
            switch (tok.getType()) {
                case 298: {
                    int idx = (Integer)tok.getValue();
                    return this.stringify(tok, this.args.get(idx));
                }
                case 296: {
                    int idx = (Integer)tok.getValue();
                    this.arg = this.args.get(idx).expansion();
                    continue block5;
                }
                case 297: {
                    this.paste(tok);
                    continue block5;
                }
            }
            break;
        }
        return tok;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("expansion of ").append(this.macro.getName());
        Source parent = this.getParent();
        if (parent != null) {
            buf.append(" in ").append(String.valueOf(parent));
        }
        return buf.toString();
    }
}

