/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import com.google.common.base.Stopwatch;
import foundry.veil.Veil;
import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.imgui.CodeEditor;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.opencl.CLBuffer;
import foundry.veil.api.opencl.CLEnvironment;
import foundry.veil.api.opencl.CLException;
import foundry.veil.api.opencl.CLKernel;
import foundry.veil.api.opencl.VeilOpenCL;
import imgui.ImGui;
import imgui.type.ImInt;
import java.nio.IntBuffer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.system.MemoryUtil;

@ApiStatus.Internal
public class OpenCLEditor
extends SingleWindowEditor {
    public static final Component TITLE = Component.m_237115_((String)"editor.veil.example.opencl.title");
    private static final Component RUN = Component.m_237115_((String)"editor.veil.example.opencl.button.run");
    private static final Component EDIT = Component.m_237115_((String)"editor.veil.example.opencl.button.edit");
    private static final Component NO_PLATFORM = Component.m_237115_((String)"editor.veil.example.opencl.no_platform");
    private static final Component DEVICE = Component.m_237115_((String)"editor.veil.example.opencl.device");
    private static final Component NO_DEVICE = Component.m_237115_((String)"editor.veil.example.opencl.device.none");
    private static final Component ELEMENTS = Component.m_237115_((String)"editor.veil.example.opencl.elements");
    private static final Component LOCAL_WORK_GROUPS = Component.m_237115_((String)"editor.veil.example.opencl.local_work_groups");
    private final CodeEditor codeEditor;
    private String source;
    private CLEnvironment environment;
    private CLKernel kernel;
    private CLBuffer bufferA;
    private CLBuffer bufferB;
    private CLBuffer bufferC;
    private CLBuffer bufferD;
    private final ImInt elements = new ImInt(1000000);
    private final ImInt workGroups = new ImInt(1);

    public OpenCLEditor() {
        this.codeEditor = new CodeEditor((Component)Component.m_237115_((String)"gui.veil.save"));
        this.codeEditor.setSaveCallback((source, errorConsumer) -> this.compileProgram(source));
        this.source = "void kernel example(global const int* A, global const int* B, global const int* C, global int* D) {\n    int i = get_global_id(0);\n    D[i] = A[i] + B[i] + C[i];\n}\n";
        this.environment = null;
    }

    private void freeBuffers() {
        if (this.bufferA != null) {
            this.bufferA.free();
            this.bufferA = null;
        }
        if (this.bufferB != null) {
            this.bufferB.free();
            this.bufferB = null;
        }
        if (this.bufferC != null) {
            this.bufferC.free();
            this.bufferC = null;
        }
        if (this.bufferD != null) {
            this.bufferD.free();
            this.bufferD = null;
        }
    }

    private void initBuffers(int itemCount) throws CLException {
        if (this.bufferA == null) {
            this.bufferA = this.kernel.createBuffer(4, (long)itemCount * 4L);
        }
        if (this.bufferB == null) {
            this.bufferB = this.kernel.createBuffer(4, (long)itemCount * 4L);
        }
        if (this.bufferC == null) {
            this.bufferC = this.kernel.createBuffer(4, (long)itemCount * 4L);
        }
        if (this.bufferD == null) {
            this.bufferD = this.kernel.createBuffer(2, (long)itemCount * 4L);
        }
    }

    private void selectDevice(VeilOpenCL.DeviceInfo deviceInfo) {
        if (this.environment != null && Objects.equals(this.environment.getDevice(), deviceInfo)) {
            return;
        }
        if (!deviceInfo.compilerAvailable()) {
            return;
        }
        CLEnvironment environment = VeilOpenCL.get().getEnvironment();
        if (environment == null) {
            Veil.LOGGER.error("Failed to change CL device");
            return;
        }
        this.free();
        this.environment = environment;
        if (!this.source.isBlank()) {
            this.compileProgram(this.source);
        }
    }

    private void compileProgram(String source) {
        if (this.environment == null) {
            return;
        }
        ResourceLocation name = new ResourceLocation("test");
        this.environment.loadProgram(name, source);
        try {
            this.kernel = this.environment.createKernel(name, "example");
        }
        catch (CLException e) {
            Veil.LOGGER.error("Failed to compile program");
            this.kernel = null;
            return;
        }
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderComponents() {
        VeilOpenCL.PlatformInfo[] platforms = VeilOpenCL.get().getPlatforms();
        if (platforms.length == 0) {
            VeilImGuiUtil.component((FormattedText)NO_PLATFORM);
            return;
        }
        VeilOpenCL.DeviceInfo deviceInfo = this.environment != null ? this.environment.getDevice() : null;
        if (ImGui.beginCombo(DEVICE.getString(), deviceInfo == null ? NO_DEVICE.getString() : deviceInfo.name())) {
            for (VeilOpenCL.PlatformInfo platform : platforms) {
                for (VeilOpenCL.DeviceInfo device : platform.devices()) {
                    if (!device.compilerAvailable() || !ImGui.selectable(platform.vendor() + " " + device.name(), deviceInfo == device)) continue;
                    this.selectDevice(device);
                }
            }
            ImGui.endCombo();
        }
        ImGui.beginDisabled(deviceInfo == null);
        if (ImGui.button(EDIT.getString())) {
            this.codeEditor.show(null, this.source);
        }
        ImGui.endDisabled();
        ImGui.beginDisabled(this.kernel == null);
        ImGui.sameLine();
        if (ImGui.button(RUN.getString())) {
            Stopwatch upload = Stopwatch.createStarted();
            int itemCount = this.elements.get();
            IntBuffer A = MemoryUtil.memAllocInt(itemCount);
            IntBuffer B = MemoryUtil.memAllocInt(itemCount);
            IntBuffer C = MemoryUtil.memAllocInt(itemCount);
            IntBuffer D = MemoryUtil.memAllocInt(itemCount);
            try {
                for (int i = 0; i < itemCount; ++i) {
                    A.put(i, i);
                    B.put(i, itemCount - i);
                    C.put(i, 2 * i);
                }
                upload.stop();
                Stopwatch execute = Stopwatch.createStarted();
                this.initBuffers(itemCount);
                this.bufferA.writeAsync(0L, A, null);
                this.bufferB.writeAsync(0L, B, null);
                this.bufferC.writeAsync(0L, C, null);
                this.kernel.setPointers(0, this.bufferA);
                this.kernel.setPointers(1, this.bufferB);
                this.kernel.setPointers(2, this.bufferC);
                this.kernel.setPointers(3, this.bufferD);
                this.kernel.execute(itemCount, this.workGroups.get());
                this.bufferD.readAsync(0L, D, null);
                this.environment.finish();
                execute.stop();
                System.out.printf("Done in " + (upload.elapsed(TimeUnit.NANOSECONDS) + execute.elapsed(TimeUnit.NANOSECONDS)) / 1000000L + "ms (%s upload, %s execute, %sns/item)\n", upload, execute, execute.elapsed(TimeUnit.NANOSECONDS) / (long)itemCount);
            }
            catch (Throwable t) {
                Veil.LOGGER.error("Failed to run OpenCL", t);
            }
            finally {
                MemoryUtil.memFree(A);
                MemoryUtil.memFree(B);
                MemoryUtil.memFree(C);
                MemoryUtil.memFree(D);
            }
        }
        ImGui.endDisabled();
        if (ImGui.dragScalar(ELEMENTS.getString(), 5, this.elements, 1000.0f, 0, 100000000)) {
            this.freeBuffers();
        }
        int max = this.kernel != null ? this.kernel.getMaxWorkGroupSize() : Integer.MAX_VALUE;
        ImGui.beginDisabled(this.kernel == null);
        ImGui.sliderScalar(LOCAL_WORK_GROUPS.getString(), 5, this.workGroups, 1, max);
        ImGui.endDisabled();
    }

    @Override
    public void onHide() {
        super.onHide();
        this.free();
    }

    @Override
    public void free() {
        this.freeBuffers();
    }

    @Override
    public void render() {
        super.render();
        this.codeEditor.renderWindow();
    }

    @Override
    public Component getDisplayName() {
        return TITLE;
    }

    @Override
    public Component getGroup() {
        return EXAMPLE_GROUP;
    }
}

