/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompositeReloadListener
implements PreparableReloadListener {
    private final PreparableReloadListener[] listeners;

    private CompositeReloadListener(PreparableReloadListener[] listeners) {
        this.listeners = listeners;
    }

    public static PreparableReloadListener of(PreparableReloadListener ... listeners) {
        if (listeners.length == 0) {
            return new PreparableReloadListener(){

                @NotNull
                public CompletableFuture<Void> m_5540_(@NotNull PreparableReloadListener.PreparationBarrier preparationBarrier, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller prepareProfiler, @NotNull ProfilerFiller applyProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
                    return preparationBarrier.m_6769_(null);
                }

                @NotNull
                public String m_7812_() {
                    return "EmptyListener";
                }
            };
        }
        if (listeners.length == 1) {
            return listeners[0];
        }
        return new CompositeReloadListener(listeners);
    }

    @NotNull
    public CompletableFuture<Void> m_5540_(final @NotNull PreparableReloadListener.PreparationBarrier preparationBarrier, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller prepareProfiler, @NotNull ProfilerFiller applyProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        final CompletableFuture allComplete = new CompletableFuture();
        final HashSet<PreparableReloadListener> preparingListeners = new HashSet<PreparableReloadListener>(Arrays.asList(this.listeners));
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(this.listeners.length);
        for (final PreparableReloadListener listener : this.listeners) {
            PreparableReloadListener.PreparationBarrier barrier = new PreparableReloadListener.PreparationBarrier(){

                @NotNull
                public <T> CompletableFuture<T> m_6769_(@Nullable T value) {
                    preparingListeners.remove(listener);
                    if (preparingListeners.isEmpty()) {
                        preparationBarrier.m_6769_(null).thenRun(() -> allComplete.complete(Unit.INSTANCE));
                    }
                    return allComplete.thenApply(unused -> value);
                }
            };
            futures.add(listener.m_5540_(barrier, resourceManager, prepareProfiler, applyProfiler, backgroundExecutor, gameExecutor));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    @NotNull
    public String m_7812_() {
        return "CompositeListener[" + Arrays.stream(this.listeners).map(PreparableReloadListener::m_7812_).collect(Collectors.joining(",")) + "]";
    }
}

