/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Locale;
import java.util.Map;

public class VertexFormatCodec {
    private static final Map<String, VertexFormatElement> DEFAULT_ELEMENTS = Map.of("POSITION", DefaultVertexFormat.f_85804_, "COLOR", DefaultVertexFormat.f_85805_, "UV0", DefaultVertexFormat.f_85806_, "UV1", DefaultVertexFormat.f_85807_, "UV2", DefaultVertexFormat.f_85808_, "NORMAL", DefaultVertexFormat.f_85809_, "PADDING", DefaultVertexFormat.f_85810_, "UV", DefaultVertexFormat.f_166849_);
    private static final Map<String, VertexFormat> DEFAULT_FORMATS = Map.ofEntries(Map.entry("BLIT_SCREEN", DefaultVertexFormat.f_166850_), Map.entry("BLOCK", DefaultVertexFormat.f_85811_), Map.entry("NEW_ENTITY", DefaultVertexFormat.f_85812_), Map.entry("PARTICLE", DefaultVertexFormat.f_85813_), Map.entry("POSITION", DefaultVertexFormat.f_85814_), Map.entry("POSITION_COLOR", DefaultVertexFormat.f_85815_), Map.entry("POSITION_COLOR_NORMAL", DefaultVertexFormat.f_166851_), Map.entry("POSITION_COLOR_LIGHTMAP", DefaultVertexFormat.f_85816_), Map.entry("POSITION_TEX", DefaultVertexFormat.f_85817_), Map.entry("POSITION_COLOR_TEX", DefaultVertexFormat.f_85818_), Map.entry("POSITION_TEX_COLOR", DefaultVertexFormat.f_85819_), Map.entry("POSITION_COLOR_TEX_LIGHTMAP", DefaultVertexFormat.f_85820_), Map.entry("POSITION_TEX_LIGHTMAP_COLOR", DefaultVertexFormat.f_85821_), Map.entry("POSITION_TEX_COLOR_NORMAL", DefaultVertexFormat.f_85822_));
    private static final Object2IntMap<String> DEFAULT_BUFFER_SIZES = new Object2IntArrayMap(Map.of("BIG", 0x200000, "MEDIUM", 262144, "SMALL", 131072, "TRANSIENT", 256));
    private static final Codec<VertexFormatElement.Type> ELEMENT_TYPE_CODEC = Codec.STRING.flatXmap(name -> {
        for (VertexFormatElement.Type type : VertexFormatElement.Type.values()) {
            if (!type.name().equalsIgnoreCase((String)name)) continue;
            return DataResult.success((Object)type);
        }
        return DataResult.error(() -> "Unknown element type: " + name.toLowerCase(Locale.ROOT));
    }, type -> DataResult.success((Object)type.name().toLowerCase(Locale.ROOT)));
    private static final Codec<VertexFormatElement.Usage> ELEMENT_USAGE_CODEC = Codec.STRING.flatXmap(name -> {
        for (VertexFormatElement.Usage usage : VertexFormatElement.Usage.values()) {
            if (!usage.name().equalsIgnoreCase((String)name)) continue;
            return DataResult.success((Object)usage);
        }
        return DataResult.error(() -> "Unknown mode: " + name.toLowerCase(Locale.ROOT));
    }, usage -> DataResult.success((Object)usage.name().toLowerCase(Locale.ROOT)));
    public static final Codec<VertexFormat.Mode> MODE_CODEC = Codec.STRING.flatXmap(name -> {
        for (VertexFormat.Mode mode : VertexFormat.Mode.values()) {
            if (!mode.name().equalsIgnoreCase((String)name)) continue;
            return DataResult.success((Object)mode);
        }
        return DataResult.error(() -> "Unknown mode: " + name.toLowerCase(Locale.ROOT));
    }, mode -> DataResult.success((Object)mode.name().toLowerCase(Locale.ROOT)));
    private static final Codec<VertexFormatElement> DEFAULT_ELEMENT_CODEC = Codec.STRING.flatXmap(name -> {
        String key = name.toUpperCase(Locale.ROOT);
        VertexFormatElement element = DEFAULT_ELEMENTS.get(key);
        return element != null ? DataResult.success((Object)element) : DataResult.error(() -> "Unknown default element: " + key);
    }, element -> {
        for (Map.Entry<String, VertexFormatElement> entry : DEFAULT_ELEMENTS.entrySet()) {
            if (!element.equals((Object)entry.getValue())) continue;
            return DataResult.success((Object)entry.getKey());
        }
        return DataResult.error(() -> "Unknown default element for: " + element);
    });
    private static final Codec<VertexFormatElement> FULL_ELEMENT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("index").forGetter(VertexFormatElement::m_86049_), (App)ELEMENT_TYPE_CODEC.fieldOf("type").forGetter(VertexFormatElement::m_86041_), (App)ELEMENT_USAGE_CODEC.fieldOf("usage").forGetter(VertexFormatElement::m_86048_), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("count").forGetter(VertexFormatElement::m_166969_)).apply((Applicative)instance, VertexFormatElement::new));
    public static final Codec<VertexFormatElement> ELEMENT_CODEC = Codec.either(DEFAULT_ELEMENT_CODEC, FULL_ELEMENT_CODEC).xmap(either -> (VertexFormatElement)either.map(a -> a, a -> a), element -> {
        for (Map.Entry<String, VertexFormatElement> entry : DEFAULT_ELEMENTS.entrySet()) {
            if (!element.equals((Object)entry.getValue())) continue;
            return Either.left((Object)element);
        }
        return Either.right((Object)element);
    });
    private static final Codec<VertexFormat> DEFAULT_CODEC = Codec.STRING.flatXmap(name -> {
        String key = name.toUpperCase(Locale.ROOT);
        VertexFormat format = DEFAULT_FORMATS.get(key);
        return format != null ? DataResult.success((Object)format) : DataResult.error(() -> "Unknown default vertex format: " + key);
    }, format -> {
        for (Map.Entry<String, VertexFormat> entry : DEFAULT_FORMATS.entrySet()) {
            if (!format.equals((Object)entry.getValue())) continue;
            return DataResult.success((Object)entry.getKey());
        }
        return DataResult.error(() -> "Unknown default vertex format for: " + format);
    });
    private static final Codec<VertexFormat> FULL_CODEC = Codec.unboundedMap((Codec)Codec.STRING, ELEMENT_CODEC).xmap(map -> new VertexFormat(ImmutableMap.copyOf((Map)map)), format -> {
        ImmutableList keys = format.m_166911_();
        ImmutableList values = format.m_86023_();
        ImmutableMap.Builder map = ImmutableMap.builderWithExpectedSize((int)keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            map.put((Object)((String)keys.get(i)), (Object)((VertexFormatElement)values.get(i)));
        }
        return map.build();
    });
    public static final Codec<VertexFormat> CODEC = Codec.either(DEFAULT_CODEC, FULL_CODEC).xmap(either -> (VertexFormat)either.map(a -> a, a -> a), format -> {
        for (Map.Entry<String, VertexFormat> entry : DEFAULT_FORMATS.entrySet()) {
            if (!format.equals((Object)entry.getValue())) continue;
            return Either.left((Object)format);
        }
        return Either.right((Object)format);
    });
    private static final Codec<Integer> DEFAULT_SIZE_CODEC = Codec.STRING.flatXmap(name -> {
        String key = name.toUpperCase(Locale.ROOT);
        int format = DEFAULT_BUFFER_SIZES.getOrDefault((Object)key, -1);
        return format != -1 ? DataResult.success((Object)format) : DataResult.error(() -> "Unknown default buffer size: " + key);
    }, format -> {
        for (Object2IntMap.Entry entry : DEFAULT_BUFFER_SIZES.object2IntEntrySet()) {
            if (format.intValue() != entry.getIntValue()) continue;
            return DataResult.success((Object)((String)entry.getKey()));
        }
        return DataResult.error(() -> "Unknown default vertex format for: " + format);
    });
    public static final Codec<Integer> BUFFER_SIZE_CODEC = Codec.either(DEFAULT_SIZE_CODEC, (Codec)Codec.intRange((int)0, (int)Integer.MAX_VALUE)).xmap(either -> (Integer)either.map(a -> a, a -> a), format -> {
        for (Object2IntMap.Entry entry : DEFAULT_BUFFER_SIZES.object2IntEntrySet()) {
            if (format.intValue() != entry.getIntValue()) continue;
            return Either.left((Object)format);
        }
        return Either.right((Object)format);
    });
}

