/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.rendertype;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.api.client.render.VeilVertexFormat;
import foundry.veil.api.client.render.shader.VeilShaders;
import foundry.veil.mixin.accessor.RenderTypeAccessor;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;

public final class VeilRenderType
extends RenderType {
    private static final RenderStateShard.ShaderStateShard PARTICLE = VeilRenderBridge.shaderState(VeilShaders.PARTICLE);
    private static final RenderStateShard.ShaderStateShard PARTICLE_ADD = VeilRenderBridge.shaderState(VeilShaders.PARTICLE_ADD);
    private static final RenderStateShard.ShaderStateShard SKINNED_MESH = VeilRenderBridge.shaderState(VeilShaders.SKINNED_MESH);
    private static final BiFunction<ResourceLocation, Boolean, RenderType> QUASAR_PARTICLE = Util.m_143821_((texture, additive) -> {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(additive != false ? PARTICLE_ADD : PARTICLE).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(additive != false ? f_110135_ : f_110139_).m_110671_(f_110152_).m_110687_(additive != false ? f_110115_ : f_110114_).m_110691_(false);
        return VeilRenderType.m_173215_((String)"veil:quasar_particle", (VertexFormat)DefaultVertexFormat.f_85813_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)131072, (boolean)false, (additive == false ? 1 : 0) != 0, (RenderType.CompositeState)state);
    });
    private static final Function<ResourceLocation, RenderType> QUASAR_TRAIL = Util.m_143827_(texture -> {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_234323_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(f_110135_).m_110687_(f_110115_).m_110661_(f_110110_).m_110691_(false);
        return RenderType.m_173215_((String)"veil:quasar_trail", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_STRIP, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    });
    private static final Function<ResourceLocation, RenderType> NECROMANCER_SKINNED_MESH = Util.m_143827_(texture -> {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(SKINNED_MESH).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(f_110134_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(true);
        return RenderType.m_173215_((String)"veil:skinned_mesh", (VertexFormat)VeilVertexFormat.SKINNED_MESH, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)131072, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    });

    public static RenderType quasarParticle(ResourceLocation texture, boolean additive) {
        return QUASAR_PARTICLE.apply(texture, additive);
    }

    public static RenderType quasarTrail(ResourceLocation texture) {
        return QUASAR_TRAIL.apply(texture);
    }

    public static RenderType layered(RenderType ... layers) {
        if (layers.length == 0) {
            throw new IllegalArgumentException("At least 1 render type must be specified");
        }
        if (layers.length == 1) {
            return layers[0];
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        VertexFormat format = layers[0].m_110508_();
        VertexFormat.Mode mode = layers[0].m_173186_();
        int bufferSize = layers[0].m_110507_();
        boolean sortOnUpload = ((RenderTypeAccessor)layers[0]).isSortOnUpload();
        for (int i = 1; i < layers.length; ++i) {
            RenderType layer = layers[i];
            if (!layer.m_110508_().equals((Object)format)) {
                throw new IllegalArgumentException("Expected " + layer + " to use " + format + ", but was " + layer.m_110508_());
            }
            if (!layer.m_173186_().equals((Object)mode)) {
                throw new IllegalArgumentException("Expected " + layer + " to use " + mode + ", but was " + layer.m_173186_());
            }
            bufferSize = Math.max(bufferSize, layer.m_110507_());
            if (((RenderTypeAccessor)layer).isSortOnUpload()) {
                sortOnUpload = true;
            }
            builder.add((Object)layer);
        }
        return new LayeredRenderType(layers[0], (List<RenderType>)builder.build(), "LayeredRenderType[" + Arrays.stream(layers).map(RenderType::toString) + "]", bufferSize, sortOnUpload);
    }

    private VeilRenderType(String $$0, VertexFormat $$1, VertexFormat.Mode $$2, int $$3, boolean $$4, boolean $$5, Runnable $$6, Runnable $$7) {
        super($$0, $$1, $$2, $$3, $$4, $$5, $$6, $$7);
    }

    public static class LayeredRenderType
    extends RenderType {
        private final List<RenderType> layers;

        private LayeredRenderType(RenderType defaultValue, List<RenderType> layers, String name, int bufferSize, boolean sortOnUpload) {
            super(name, defaultValue.m_110508_(), defaultValue.m_173186_(), bufferSize, defaultValue.m_110405_(), sortOnUpload, () -> ((RenderType)defaultValue).m_110185_(), () -> ((RenderType)defaultValue).m_110188_());
            this.layers = layers;
        }

        public void m_276775_(BufferBuilder builder, VertexSorting sorting) {
            BufferUploader.m_231208_();
            super.m_276775_(builder, sorting);
            if (BufferUploader.f_231201_ != null) {
                for (RenderType layer : this.layers) {
                    layer.m_110185_();
                    ShaderInstance shader = RenderSystem.getShader();
                    shader.m_173363_();
                    BufferUploader.f_231201_.m_166882_();
                    shader.m_173362_();
                    layer.m_110188_();
                }
            }
        }
    }
}

