/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.util.TextureDownloader;
import imgui.ImGui;
import imgui.type.ImBoolean;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL20C;

@ApiStatus.Internal
public class TextureEditor
extends SingleWindowEditor {
    public static final Component TITLE = Component.m_237115_((String)"editor.veil.texture.title");
    public static final Component DOWNLOAD = Component.m_237115_((String)"editor.veil.texture.button.download");
    public static final Component POP_OUT = Component.m_237115_((String)"editor.veil.texture.toggle.pop_out");
    public static final Component FLIP_X = Component.m_237115_((String)"editor.veil.texture.toggle.flip_x");
    public static final Component FLIP_Y = Component.m_237115_((String)"editor.veil.texture.toggle.flip_y");
    public static final Component NO_TEXTURE = Component.m_237115_((String)"editor.veil.texture.asset.missing");
    private final IntSet texturesSet = new IntArraySet();
    private final Map<Integer, OpenTexture> openTextures = new HashMap<Integer, OpenTexture>();
    private final ImBoolean flipX = new ImBoolean();
    private final ImBoolean flipY = new ImBoolean();
    private int[] textures = new int[0];
    private int selectedTexture = 0;
    private boolean downloadTextures;
    private CompletableFuture<?> downloadFuture = null;

    private void scanTextures() {
        this.texturesSet.clear();
        for (int i = 0; i < 10000; ++i) {
            if (!GL20C.glIsTexture((int)i)) continue;
            this.texturesSet.add(i);
        }
        if (this.textures.length != this.texturesSet.size()) {
            if (!this.texturesSet.contains(this.selectedTexture)) {
                this.selectedTexture = 0;
            }
            this.textures = this.texturesSet.toIntArray();
            this.openTextures.keySet().removeIf(a -> !this.texturesSet.contains(a.intValue()));
        }
    }

    @Override
    public Component getDisplayName() {
        return TITLE;
    }

    @Override
    public Component getGroup() {
        return RENDERER_GROUP;
    }

    @Override
    protected void renderComponents() {
        this.scanTextures();
        int selectedId = this.selectedTexture < 0 || this.selectedTexture >= this.textures.length ? 0 : this.textures[this.selectedTexture];
        int[] value = new int[]{this.selectedTexture};
        ImGui.beginDisabled((this.textures.length == 0 ? 1 : 0) != 0);
        ImGui.setNextItemWidth((float)(ImGui.getContentRegionAvailX() / 2.0f));
        if (ImGui.sliderInt((String)"##textures", (int[])value, (int)0, (int)(this.textures.length - 1), (String)(selectedId == 0 ? NO_TEXTURE.getString() : Integer.toString(selectedId)))) {
            this.selectedTexture = value[0];
        }
        ImGui.endDisabled();
        ImGui.sameLine();
        ImGui.pushButtonRepeat((boolean)true);
        ImGui.beginDisabled((this.selectedTexture <= 0 ? 1 : 0) != 0);
        if (ImGui.arrowButton((String)"##left", (int)0)) {
            --this.selectedTexture;
        }
        ImGui.endDisabled();
        ImGui.beginDisabled((this.selectedTexture >= this.textures.length - 1 ? 1 : 0) != 0);
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.arrowButton((String)"##right", (int)1)) {
            ++this.selectedTexture;
        }
        ImGui.endDisabled();
        ImGui.popButtonRepeat();
        ImGui.beginDisabled((this.downloadFuture != null && !this.downloadFuture.isDone() ? 1 : 0) != 0);
        ImGui.sameLine();
        if (ImGui.button((String)DOWNLOAD.getString())) {
            this.downloadTextures = true;
            this.downloadFuture = new CompletableFuture();
        }
        ImGui.endDisabled();
        ImGui.beginDisabled((this.openTextures.containsKey(selectedId) && this.openTextures.get((Object)Integer.valueOf((int)selectedId)).visible.get() ? 1 : 0) != 0);
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.button((String)POP_OUT.getString())) {
            this.openTextures.put(selectedId, new OpenTexture(this.flipX.get(), this.flipY.get()));
        }
        ImGui.endDisabled();
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.checkbox((String)FLIP_X.getString(), (ImBoolean)this.flipX);
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.checkbox((String)FLIP_Y.getString(), (ImBoolean)this.flipY);
        if (selectedId != 0) {
            TextureEditor.addImage(selectedId, this.flipX.get(), this.flipY.get());
        }
    }

    @Override
    public void render() {
        super.render();
        Iterator<Map.Entry<Integer, OpenTexture>> iterator = this.openTextures.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, OpenTexture> entry = iterator.next();
            int id = entry.getKey();
            OpenTexture texture = entry.getValue();
            if (!texture.visible.get()) continue;
            ImBoolean open = texture.open;
            if (!open.get()) {
                open.set(true);
                ImGui.setNextWindowSize((float)800.0f, (float)600.0f);
            }
            if (ImGui.begin((String)I18n.m_118938_((String)"editor.veil.texture.asset", (Object[])new Object[]{id}), (ImBoolean)open, (int)256)) {
                ImBoolean flipX = texture.flipX;
                ImBoolean flipY = texture.flipY;
                ImGui.checkbox((String)FLIP_X.getString(), (ImBoolean)flipX);
                ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
                ImGui.checkbox((String)FLIP_Y.getString(), (ImBoolean)flipY);
                TextureEditor.addImage(id, flipX.get(), flipY.get());
            }
            ImGui.end();
            if (open.get()) continue;
            iterator.remove();
        }
    }

    @Override
    public void renderLast() {
        super.renderLast();
        if (this.downloadTextures) {
            this.downloadTextures = false;
            try {
                Minecraft client = Minecraft.m_91087_();
                Path outputFolder = Paths.get(client.f_91069_.toURI()).resolve("debug-out");
                if (!Files.exists(outputFolder, new LinkOption[0])) {
                    Files.createDirectories(outputFolder, new FileAttribute[0]);
                } else {
                    Files.walkFileTree(outputFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                LinkedList result = new LinkedList();
                IntIterator intIterator = this.texturesSet.iterator();
                while (intIterator.hasNext()) {
                    int i = (Integer)intIterator.next();
                    result.add(TextureDownloader.save(Integer.toString(i), outputFolder, i, false));
                }
                this.downloadFuture = CompletableFuture.allOf(result.toArray(new CompletableFuture[0])).thenRunAsync(() -> Util.m_137581_().m_137644_(outputFolder.toFile()), (Executor)client);
            }
            catch (Exception e) {
                Veil.LOGGER.error("Failed to download textures", (Throwable)e);
            }
        }
    }

    @Override
    public void renderMenuBar() {
        for (Map.Entry<Integer, OpenTexture> entry : this.openTextures.entrySet()) {
            ImGui.menuItem((String)I18n.m_118938_((String)"editor.veil.texture.asset", (Object[])new Object[]{entry.getKey()}), null, (ImBoolean)entry.getValue().visible);
        }
    }

    @Override
    public boolean isMenuBarEnabled() {
        return !this.openTextures.isEmpty();
    }

    @Override
    public void onHide() {
        super.onHide();
        this.texturesSet.clear();
        this.textures = new int[0];
        this.selectedTexture = 0;
    }

    private static void addImage(int selectedId, boolean flipX, boolean flipY) {
        RenderSystem.bindTexture((int)selectedId);
        int width = GL11C.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int height = GL11C.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        float size = ImGui.getContentRegionAvailX();
        ImGui.image((int)selectedId, (float)size, (float)(size * (float)height / (float)width), (float)(flipX ? 1.0f : 0.0f), (float)(flipY ? 1.0f : 0.0f), (float)(flipX ? 0.0f : 1.0f), (float)(flipY ? 0.0f : 1.0f), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private record OpenTexture(ImBoolean open, ImBoolean visible, ImBoolean flipX, ImBoolean flipY) {
        private OpenTexture(boolean flipX, boolean flipY) {
            this(new ImBoolean(), new ImBoolean(true), new ImBoolean(flipX), new ImBoolean(flipY));
        }
    }
}

