/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.deferred.VeilDeferredRenderer;
import foundry.veil.api.client.render.deferred.light.renderer.LightRenderer;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import foundry.veil.impl.client.editor.FramebufferEditor;
import imgui.ImGui;
import imgui.type.ImBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class DeferredEditor
extends SingleWindowEditor {
    public static final Component TITLE = Component.m_237115_((String)"editor.veil.deferred.title");
    private static final Component ENABLE_PIPELINE = Component.m_237115_((String)"editor.veil.deferred.toggle.pipeline");
    private static final Component ENABLE_AO = Component.m_237115_((String)"editor.veil.deferred.toggle.ao");
    private static final Component ENABLE_VANILLA_LIGHT = Component.m_237115_((String)"editor.veil.deferred.toggle.vanilla_light");
    private static final Component ENABLE_VANILLA_ENTITY_LIGHT = Component.m_237115_((String)"editor.veil.deferred.toggle.vanilla_entity_light");
    private final ImBoolean enableDeferredPipeline = new ImBoolean();
    private final ImBoolean enableAmbientOcclusion = new ImBoolean();
    private final ImBoolean enableVanillaLight = new ImBoolean();
    private final ImBoolean enableEntityLight = new ImBoolean();

    @Override
    public Component getDisplayName() {
        return TITLE;
    }

    @Override
    public Component getGroup() {
        return DEFERRED_GROUP;
    }

    @Override
    protected void renderComponents() {
        VeilRenderer renderer = VeilRenderSystem.renderer();
        ShaderPreDefinitions definitions = renderer.getShaderDefinitions();
        VeilDeferredRenderer deferredRenderer = renderer.getDeferredRenderer();
        LightRenderer lightRenderer = deferredRenderer.getLightRenderer();
        this.enableDeferredPipeline.set(deferredRenderer.getRendererState() != VeilDeferredRenderer.RendererState.DISABLED);
        if (ImGui.checkbox((String)ENABLE_PIPELINE.getString(), (ImBoolean)this.enableDeferredPipeline)) {
            if (this.enableDeferredPipeline.get()) {
                deferredRenderer.enable();
            } else {
                deferredRenderer.disable();
            }
            Minecraft.m_91087_().f_91060_.m_109818_();
        }
        ImGui.sameLine();
        this.enableAmbientOcclusion.set(lightRenderer.isAmbientOcclusionEnabled());
        if (ImGui.checkbox((String)ENABLE_AO.getString(), (ImBoolean)this.enableAmbientOcclusion)) {
            if (this.enableAmbientOcclusion.get()) {
                lightRenderer.enableAmbientOcclusion();
            } else {
                lightRenderer.disableAmbientOcclusion();
            }
        }
        ImGui.sameLine();
        this.enableVanillaLight.set(lightRenderer.isVanillaLightEnabled());
        if (ImGui.checkbox((String)ENABLE_VANILLA_LIGHT.getString(), (ImBoolean)this.enableVanillaLight)) {
            if (this.enableVanillaLight.get()) {
                lightRenderer.enableVanillaLight();
            } else {
                lightRenderer.disableVanillaLight();
            }
        }
        ImGui.sameLine();
        this.enableEntityLight.set(definitions.getDefinition("DISABLE_VANILLA_ENTITY_LIGHT") == null);
        if (ImGui.checkbox((String)ENABLE_VANILLA_ENTITY_LIGHT.getString(), (ImBoolean)this.enableEntityLight)) {
            if (this.enableEntityLight.get()) {
                definitions.remove("DISABLE_VANILLA_ENTITY_LIGHT");
            } else {
                definitions.define("DISABLE_VANILLA_ENTITY_LIGHT");
            }
        }
        VeilImGuiUtil.component((FormattedText)FramebufferEditor.TITLE);
        if (ImGui.beginTabBar((String)"##framebuffers")) {
            FramebufferEditor.drawBuffers(VeilFramebuffers.OPAQUE, null);
            FramebufferEditor.drawBuffers(VeilFramebuffers.OPAQUE_LIGHT, null);
            FramebufferEditor.drawBuffers(VeilFramebuffers.OPAQUE_FINAL, null);
            FramebufferEditor.drawBuffers(VeilFramebuffers.TRANSPARENT, null);
            FramebufferEditor.drawBuffers(VeilFramebuffers.TRANSPARENT_LIGHT, null);
            FramebufferEditor.drawBuffers(VeilFramebuffers.TRANSPARENT_FINAL, null);
            ImGui.endTabBar();
        }
    }

    @Override
    public boolean isEnabled() {
        return VeilRenderSystem.renderer().getDeferredRenderer().isEnabled();
    }
}

