/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_preprocessor;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.github.douira.glsl_preprocessor.LexerException;
import io.github.douira.glsl_preprocessor.Source;
import io.github.douira.glsl_preprocessor.Token;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SourceIterator
implements Iterator<Token> {
    private final Source source;
    private Token tok;

    public SourceIterator(@NonNull Source s) {
        this.source = s;
        this.tok = null;
    }

    private void advance() {
        try {
            if (this.tok == null) {
                this.tok = this.source.token();
            }
        }
        catch (LexerException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean hasNext() {
        this.advance();
        return this.tok.getType() != 265;
    }

    @Override
    public Token next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Token t = this.tok;
        this.tok = null;
        return t;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

