/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.lib.antlr.v4.codegen.model;

import foundry.veil.lib.antlr.v4.codegen.ActionTranslator;
import foundry.veil.lib.antlr.v4.codegen.CodeGenerator;
import foundry.veil.lib.antlr.v4.codegen.ParserFactory;
import foundry.veil.lib.antlr.v4.codegen.Target;
import foundry.veil.lib.antlr.v4.codegen.model.LabeledOp;
import foundry.veil.lib.antlr.v4.codegen.model.ModelElement;
import foundry.veil.lib.antlr.v4.codegen.model.RuleElement;
import foundry.veil.lib.antlr.v4.codegen.model.RuleFunction;
import foundry.veil.lib.antlr.v4.codegen.model.chunk.ActionChunk;
import foundry.veil.lib.antlr.v4.codegen.model.decl.Decl;
import foundry.veil.lib.antlr.v4.codegen.model.decl.RuleContextDecl;
import foundry.veil.lib.antlr.v4.codegen.model.decl.RuleContextListDecl;
import foundry.veil.lib.antlr.v4.runtime.misc.OrderedHashSet;
import foundry.veil.lib.antlr.v4.tool.Rule;
import foundry.veil.lib.antlr.v4.tool.ast.ActionAST;
import foundry.veil.lib.antlr.v4.tool.ast.GrammarAST;
import java.util.List;

public class InvokeRule
extends RuleElement
implements LabeledOp {
    public final String name;
    public final String escapedName;
    public final OrderedHashSet<Decl> labels = new OrderedHashSet();
    public final String ctxName;
    @ModelElement
    public List<ActionChunk> argExprsChunks;

    public InvokeRule(ParserFactory factory, GrammarAST ast, GrammarAST labelAST) {
        super(factory, ast);
        ActionAST arg;
        String label;
        if (ast.atnState != null) {
            this.stateNumber = ast.atnState.stateNumber;
        }
        CodeGenerator gen = factory.getGenerator();
        Target target = gen.getTarget();
        String identifier = ast.getText();
        Rule r = factory.getGrammar().getRule(identifier);
        this.name = r.name;
        this.escapedName = gen.getTarget().escapeIfNeeded(this.name);
        this.ctxName = target.getRuleFunctionContextStructName(r);
        RuleFunction rf = factory.getCurrentRuleFunction();
        if (labelAST != null) {
            RuleContextDecl decl;
            label = labelAST.getText();
            if (labelAST.parent.getType() == 46) {
                factory.defineImplicitLabel(ast, this);
                String listLabel = gen.getTarget().getListLabel(label);
                decl = new RuleContextListDecl(factory, listLabel, this.ctxName);
            } else {
                decl = new RuleContextDecl(factory, label, this.ctxName);
                this.labels.add(decl);
            }
            rf.addContextDecl(ast.getAltLabel(), decl);
        }
        if ((arg = (ActionAST)ast.getFirstChildWithType(8)) != null) {
            this.argExprsChunks = ActionTranslator.translateAction(factory, rf, arg.token, arg);
        }
        if (factory.getCurrentOuterMostAlt().ruleRefsInActions.containsKey(identifier)) {
            label = gen.getTarget().getImplicitRuleLabel(identifier);
            RuleContextDecl d = new RuleContextDecl(factory, label, this.ctxName);
            this.labels.add(d);
            rf.addContextDecl(ast.getAltLabel(), d);
        }
    }

    @Override
    public List<Decl> getLabels() {
        return this.labels.elements();
    }
}

