/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.processor;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.ShaderModificationManager;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class ShaderModifyProcessor
implements ShaderPreProcessor {
    private final ShaderModificationManager shaderModificationManager = VeilRenderSystem.renderer().getShaderModificationManager();
    private final Set<ResourceLocation> appliedModifications = new HashSet<ResourceLocation>();

    @Override
    public void prepare() {
        this.appliedModifications.clear();
    }

    @Override
    public String modify(ShaderPreProcessor.Context context, String source) throws IOException {
        ResourceLocation name = context.name();
        if (name == null || !this.appliedModifications.add(name)) {
            return source;
        }
        int flags = context.isSourceFile() ? 3 : 0;
        for (ResourceLocation include : context.includes()) {
            source = this.shaderModificationManager.applyModifiers(include, source, flags);
        }
        return this.shaderModificationManager.applyModifiers(name, source, flags);
    }
}

