/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.processor;

import foundry.veil.Veil;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import foundry.veil.lib.douira.glsl_transformer.ast.transform.TransformationException;
import foundry.veil.lib.douira.glsl_transformer.parser.ParsingException;
import io.github.douira.glsl_preprocessor.DefaultPreprocessorListener;
import io.github.douira.glsl_preprocessor.Feature;
import io.github.douira.glsl_preprocessor.Preprocessor;
import io.github.douira.glsl_preprocessor.StringLexerSource;
import java.io.IOException;

public class ShaderCPreprocessor
implements ShaderPreProcessor {
    @Override
    public String modify(ShaderPreProcessor.Context ctx, String source) throws IOException {
        Preprocessor preprocessor = new Preprocessor();
        try {
            preprocessor.setListener(new DefaultPreprocessorListener());
            preprocessor.addInput(new StringLexerSource(source, true));
            preprocessor.addFeature(Feature.KEEPCOMMENTS);
            preprocessor.addFeature(Feature.GLSL_PASSTHROUGH);
            String string = preprocessor.printToString();
            preprocessor.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    preprocessor.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (TransformationException | ParsingException | IllegalArgumentException | IllegalStateException e) {
                Veil.LOGGER.error("Failed to parse shader: {}", (Object)ctx.name(), (Object)e);
                return source;
            }
        }
    }
}

