/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.CompiledShader;
import foundry.veil.api.client.render.shader.ShaderCompiler;
import foundry.veil.api.client.render.shader.ShaderException;
import foundry.veil.api.client.render.shader.program.MutableUniformAccess;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.client.render.shader.program.TextureUniformAccess;
import foundry.veil.api.client.render.shader.texture.ShaderTextureSource;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.opengl.GL31C;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.system.MemoryUtil;

@ApiStatus.Internal
public class ShaderProgramImpl
implements ShaderProgram {
    private final ResourceLocation id;
    private final Int2ObjectMap<CompiledShader> shaders;
    private final Object2IntMap<CharSequence> uniforms;
    private final Object2IntMap<CharSequence> uniformBlocks;
    private final Object2IntMap<CharSequence> storageBlocks;
    private final Map<String, ShaderTextureSource> textureSources;
    private final Set<String> definitionDependencies;
    private final TextureCache textures;
    private final Supplier<Wrapper> wrapper;
    private ProgramDefinition definition;
    private int program;

    public ShaderProgramImpl(ResourceLocation id) {
        this.id = id;
        this.shaders = new Int2ObjectArrayMap(2);
        this.uniforms = new Object2IntArrayMap();
        this.uniformBlocks = new Object2IntArrayMap();
        this.storageBlocks = new Object2IntArrayMap();
        this.textures = new TextureCache(this);
        this.textureSources = new HashMap<String, ShaderTextureSource>();
        this.definitionDependencies = new HashSet<String>();
        this.wrapper = Suppliers.memoize(() -> {
            Wrapper.constructing = true;
            try {
                Wrapper wrapper = new Wrapper(this);
                return wrapper;
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to wrap shader program: " + this.getId(), e);
            }
            finally {
                Wrapper.constructing = false;
            }
        });
    }

    private void clearShader() {
        if (this.program != 0) {
            this.shaders.values().forEach(shader -> GL43C.glDetachShader((int)this.program, (int)shader.id()));
        }
        this.shaders.clear();
        this.uniforms.clear();
        this.uniformBlocks.clear();
        this.textures.clear();
        this.textureSources.clear();
        this.definitionDependencies.clear();
    }

    @Override
    public void compile(ShaderCompiler.Context context, ShaderCompiler compiler) throws Exception {
        this.definition = Objects.requireNonNull(context.definition());
        this.clearShader();
        this.textureSources.putAll(this.definition.textures());
        if (this.program == 0) {
            this.program = GL43C.glCreateProgram();
        }
        try {
            Int2ObjectMap<ProgramDefinition.ShaderSource> shaders = this.definition.shaders();
            for (Int2ObjectMap.Entry entry : shaders.int2ObjectEntrySet()) {
                int glType = entry.getIntKey();
                ProgramDefinition.ShaderSource source = (ProgramDefinition.ShaderSource)entry.getValue();
                CompiledShader shader2 = compiler.compile(context, glType, source.sourceType(), source.location());
                GL43C.glAttachShader((int)this.program, (int)shader2.id());
                this.shaders.put(glType, (Object)shader2);
            }
            if (Minecraft.f_91002_ && !shaders.containsKey(37305) && !shaders.containsKey(35632)) {
                CompiledShader shader3 = compiler.compile(context, 35632, ProgramDefinition.SourceType.GLSL, "out vec4 fragColor;void main(){fragColor=vec4(1.0);}");
                GL43C.glAttachShader((int)this.program, (int)shader3.id());
                this.shaders.put(35632, (Object)shader3);
            }
            GL43C.glLinkProgram((int)this.program);
            if (GL43C.glGetProgrami((int)this.program, (int)35714) != 1) {
                String log = GL43C.glGetProgramInfoLog((int)this.program);
                throw new ShaderException("Failed to link shader", log);
            }
            this.shaders.values().forEach(shader -> {
                shader.apply(this);
                this.definitionDependencies.addAll(shader.definitionDependencies());
            });
        }
        catch (Exception e) {
            this.clearShader();
            throw e;
        }
    }

    public void free() {
        this.clearShader();
        if (this.program > 0) {
            GL43C.glDeleteProgram((int)this.program);
            this.program = 0;
        }
    }

    @Override
    public Int2ObjectMap<CompiledShader> getShaders() {
        return this.shaders;
    }

    @Override
    public Set<String> getDefinitionDependencies() {
        return this.definitionDependencies;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public Wrapper toShaderInstance() {
        return this.wrapper.get();
    }

    @Override
    public int getUniform(CharSequence name) {
        if (this.program == 0) {
            return -1;
        }
        return this.uniforms.computeIfAbsent((Object)name, k -> GL43C.glGetUniformLocation((int)this.program, (CharSequence)k));
    }

    @Override
    public int getUniformBlock(CharSequence name) {
        if (this.program == 0) {
            return -1;
        }
        return this.uniformBlocks.computeIfAbsent((Object)name, k -> GL31C.glGetUniformBlockIndex((int)this.program, (CharSequence)name));
    }

    @Override
    public int getStorageBlock(CharSequence name) {
        if (this.program == 0) {
            return -1;
        }
        return this.storageBlocks.computeIfAbsent((Object)name, k -> GL43C.glGetProgramResourceIndex((int)this.program, (int)37606, (CharSequence)name));
    }

    @Override
    public int getProgram() {
        return this.program;
    }

    @Override
    @Nullable
    public ProgramDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public int applyShaderSamplers(@Nullable ShaderTextureSource.Context context, int sampler) {
        if (context != null) {
            this.textureSources.forEach((name, source) -> this.addSampler((CharSequence)name, source.getId(context)));
        }
        return this.textures.bind(sampler);
    }

    @Override
    public void addSamplerListener(TextureUniformAccess.SamplerListener listener) {
        this.textures.addSamplerListener(listener);
    }

    @Override
    public void removeSamplerListener(TextureUniformAccess.SamplerListener listener) {
        this.textures.removeSamplerListener(listener);
    }

    @Override
    public void addSampler(CharSequence name, int textureId) {
        this.textures.put(name, textureId);
    }

    @Override
    public void removeSampler(CharSequence name) {
        this.textures.remove(name);
    }

    @Override
    public void clearSamplers() {
        this.textures.clear();
    }

    private static class TextureCache {
        private final ShaderProgram program;
        private final Object2IntMap<CharSequence> textures;
        private final Object2IntMap<CharSequence> boundSamplers;
        private final ObjectSet<TextureUniformAccess.SamplerListener> listeners;
        private boolean dirty;
        private IntBuffer bindings;

        private TextureCache(ShaderProgram program) {
            this.program = program;
            this.textures = new Object2IntArrayMap();
            this.textures.defaultReturnValue(-1);
            this.boundSamplers = new Object2IntArrayMap();
            this.listeners = new ObjectArraySet();
            this.bindings = null;
        }

        private int uploadTextures(int start, BiConsumer<Integer, Integer> textureConsumer) {
            this.boundSamplers.clear();
            if (this.textures.isEmpty()) {
                return start;
            }
            int maxSampler = VeilRenderSystem.maxCombinedTextureUnits();
            int count = 1;
            textureConsumer.accept(start, MissingTextureAtlasSprite.m_118080_().m_117963_());
            for (Object2IntMap.Entry entry : this.textures.object2IntEntrySet()) {
                CharSequence name = (CharSequence)entry.getKey();
                if (this.program.getUniform(name) == -1) continue;
                int sampler = start + count;
                if (sampler >= maxSampler) {
                    this.program.setInt(name, 0);
                    Veil.LOGGER.error("Too many samplers were bound for shader (max {}): {}", (Object)maxSampler, (Object)this.program.getId());
                    continue;
                }
                int textureId = entry.getIntValue();
                if (textureId == 0) {
                    this.program.setInt(name, 0);
                    continue;
                }
                textureConsumer.accept(sampler, textureId);
                this.program.setInt(name, sampler);
                this.boundSamplers.put((Object)name, sampler);
                ++count;
            }
            for (TextureUniformAccess.SamplerListener listener : this.listeners) {
                listener.onUpdateSamplers(this.boundSamplers);
            }
            return start + count;
        }

        public int bind(int start) {
            if (VeilRenderSystem.textureMultibindSupported()) {
                if (this.dirty) {
                    this.dirty = false;
                    if (this.bindings == null || this.bindings.capacity() < 1 + this.textures.size()) {
                        this.bindings = MemoryUtil.memRealloc((IntBuffer)this.bindings, (int)(1 + this.textures.size()));
                    }
                    this.bindings.clear();
                    int end = this.uploadTextures(start, (sampler, id) -> this.bindings.put((int)id));
                    if (end == start) {
                        this.bindings.position(0);
                        return start;
                    }
                    this.bindings.flip();
                }
                if (this.bindings != null && this.bindings.limit() > 0) {
                    VeilRenderSystem.bindTextures(start, this.bindings);
                    return start + this.bindings.limit();
                }
                return start;
            }
            this.dirty = false;
            int activeTexture = GlStateManager._getActiveTexture();
            int end = this.uploadTextures(start, (sampler, id) -> {
                RenderSystem.activeTexture((int)(33984 + sampler));
                if (sampler >= 12) {
                    GL43C.glBindTexture((int)3553, (int)id);
                } else {
                    RenderSystem.bindTexture((int)id);
                }
            });
            RenderSystem.activeTexture((int)activeTexture);
            return end;
        }

        public void addSamplerListener(TextureUniformAccess.SamplerListener listener) {
            this.listeners.add((Object)listener);
        }

        public void removeSamplerListener(TextureUniformAccess.SamplerListener listener) {
            this.listeners.remove((Object)listener);
        }

        public void put(CharSequence name, int textureId) {
            this.dirty |= this.textures.put((Object)name, textureId) != textureId;
        }

        public void remove(CharSequence name) {
            if (this.textures.removeInt((Object)name) != 0) {
                this.dirty = true;
            }
        }

        public void clear() {
            this.textures.clear();
            this.boundSamplers.clear();
            if (this.bindings != null) {
                MemoryUtil.memFree((Buffer)this.bindings);
                this.bindings = null;
            }
            this.dirty = true;
        }
    }

    public static class Wrapper
    extends ShaderInstance {
        private static final byte[] DUMMY_SHADER = "{\n    \"vertex\": \"dummy\",\n    \"fragment\": \"dummy\"\n}\n".getBytes(StandardCharsets.UTF_8);
        private static final Resource RESOURCE = new Resource(null, () -> new ByteArrayInputStream(DUMMY_SHADER)){

            public PackResources m_247173_() {
                throw new UnsupportedOperationException("No pack source");
            }

            public String m_215506_() {
                return "dummy";
            }

            public boolean m_247137_() {
                return true;
            }
        };
        public static boolean constructing = false;
        private final ShaderProgram program;

        private Wrapper(ShaderProgram program) throws IOException {
            super(name -> Optional.of(RESOURCE), "", null);
            this.program = program;
        }

        public void close() {
        }

        public void m_173362_() {
            ShaderProgram.unbind();
        }

        public void m_173363_() {
            this.program.setup();
        }

        public void m_142662_() {
            throw new UnsupportedOperationException("Cannot attach shader program wrapper");
        }

        public void m_108957_() {
        }

        @Nullable
        public UniformWrapper getUniform(String name) {
            UniformWrapper uniform = (UniformWrapper)((Object)this.f_173333_.get(name));
            if (uniform != null) {
                return uniform.m_166752_() == -1 ? null : uniform;
            }
            if (this.program != null && this.program.getUniform(name) == -1) {
                return null;
            }
            return (UniformWrapper)this.f_173333_.computeIfAbsent(name, unused -> new UniformWrapper(() -> this.program, name));
        }

        public void m_173350_(String name, Object value) {
            int sampler = -1;
            if (value instanceof RenderTarget) {
                RenderTarget target = (RenderTarget)value;
                sampler = target.m_83975_();
            } else if (value instanceof AbstractTexture) {
                AbstractTexture texture = (AbstractTexture)value;
                sampler = texture.m_117963_();
            } else if (value instanceof Integer) {
                Integer id = (Integer)value;
                sampler = id;
            }
            if (sampler != -1) {
                this.program.addSampler(name, sampler);
            }
        }

        public ShaderProgram program() {
            return this.program;
        }
    }

    public static class UniformWrapper
    extends Uniform {
        private final Supplier<MutableUniformAccess> access;

        public UniformWrapper(Supplier<MutableUniformAccess> access, String name) {
            super(name, 0, 0, null);
            super.close();
            this.access = access;
        }

        public void m_85614_(int location) {
        }

        public void m_166700_(int index, float value) {
            throw new UnsupportedOperationException("Use absolute set");
        }

        public void m_5985_(float value) {
            this.access.get().setFloat(this.m_85599_(), value);
        }

        public void m_7971_(float x, float y) {
            this.access.get().setVector(this.m_85599_(), x, y);
        }

        public void m_5889_(float x, float y, float z) {
            this.access.get().setVector(this.m_85599_(), x, y, z);
        }

        public void m_5805_(float x, float y, float z, float w) {
            this.access.get().setVector(this.m_85599_(), x, y, z, w);
        }

        public void m_142276_(@NotNull Vector3f value) {
            this.access.get().setVector((CharSequence)this.m_85599_(), (Vector3fc)value);
        }

        public void m_142558_(@NotNull Vector4f value) {
            this.access.get().setVector((CharSequence)this.m_85599_(), (Vector4fc)value);
        }

        public void m_5808_(float x, float y, float z, float w) {
            this.m_5805_(x, y, z, w);
        }

        public void m_142617_(int value) {
            this.access.get().setInt(this.m_85599_(), value);
        }

        public void m_142326_(int x, int y) {
            this.access.get().setVector(this.m_85599_(), x, y);
        }

        public void m_142693_(int x, int y, int z) {
            this.access.get().setVector(this.m_85599_(), x, y, z);
        }

        public void m_142492_(int x, int y, int z, int w) {
            this.access.get().setVector(this.m_85599_(), x, y, z, w);
        }

        public void m_7401_(int x, int y, int z, int w) {
            this.m_142492_(x, y, z, w);
        }

        public void m_5941_(float[] values) {
            switch (values.length) {
                case 1: {
                    this.m_5985_(values[0]);
                    break;
                }
                case 2: {
                    this.m_7971_(values[0], values[1]);
                    break;
                }
                case 3: {
                    this.m_5889_(values[0], values[1], values[2]);
                    break;
                }
                case 4: {
                    this.m_5805_(values[0], values[1], values[2], values[3]);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Invalid value array: " + Arrays.toString(values));
                }
            }
        }

        public void m_142588_(float $$0, float $$1, float $$2, float $$3) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void m_141964_(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void m_142005_(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void m_141963_(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void m_142217_(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void m_142604_(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void m_142004_(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void m_142605_(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void m_141978_(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11, float $$12, float $$13, float $$14, float $$15) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void m_200759_(@NotNull Matrix3f value) {
            this.access.get().setMatrix((CharSequence)this.m_85599_(), (Matrix3fc)value);
        }

        public void m_5679_(@NotNull Matrix4f value) {
            this.access.get().setMatrix((CharSequence)this.m_85599_(), (Matrix4fc)value);
        }

        public void m_85633_() {
        }

        public void close() {
        }

        public int m_166752_() {
            return this.access.get().getUniform(this.m_85599_());
        }
    }
}

