/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DebugFrustumRenderer {
    private static final Vector3f[] POSITIONS = new Vector3f[8];
    private static final Matrix4f MODELVIEW = new Matrix4f();
    private static final Matrix4f PROJECTION = new Matrix4f();

    private static int getIndex(int x, int y, int z) {
        return (z * 2 + y) * 2 + x;
    }

    private static void putLine(@NotNull VertexConsumer consumer, int x0, int y0, int z0, int x1, int y1, int z1, float red, float green, float blue, float alpha) {
        Vector3f pos0 = POSITIONS[DebugFrustumRenderer.getIndex(x0, y0, z0)];
        Vector3f pos1 = POSITIONS[DebugFrustumRenderer.getIndex(x1, y1, z1)];
        Vector3f norm = pos1.sub((Vector3fc)pos0, new Vector3f()).normalize();
        consumer.m_5483_((double)pos0.x(), (double)pos0.y(), (double)pos0.z()).m_85950_(red, green, blue, alpha).m_5601_(norm.x(), norm.y(), norm.z()).m_5752_();
        consumer.m_5483_((double)pos1.x(), (double)pos1.y(), (double)pos1.z()).m_85950_(red, green, blue, alpha).m_5601_(norm.x(), norm.y(), norm.z()).m_5752_();
    }

    public static void renderFrustum(@NotNull MultiBufferSource source, @NotNull PoseStack stack, @NotNull Matrix4fc pose, @NotNull Matrix4fc projection, float red, float green, float blue, float alpha) {
        stack.m_85836_();
        Matrix4f modelView = stack.m_85850_().m_252922_();
        modelView.mul((Matrix4fc)pose.invert(MODELVIEW));
        modelView.mul((Matrix4fc)projection.invert(PROJECTION));
        for (int z = 0; z < 2; ++z) {
            for (int x = 0; x < 2; ++x) {
                for (int y = 0; y < 2; ++y) {
                    modelView.transformPosition((float)(x * 2 - 1), (float)(y * 2 - 1), (float)(z * 2 - 1), POSITIONS[DebugFrustumRenderer.getIndex(x, y, z)]);
                }
            }
        }
        VertexConsumer consumer = source.m_6299_(RenderType.m_110504_());
        DebugFrustumRenderer.putLine(consumer, 0, 0, 0, 0, 1, 0, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 0, 0, 1, 0, 1, 1, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 0, 0, 0, 0, 0, 1, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 0, 1, 0, 1, 1, 0, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 0, 1, 1, 1, 1, 1, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 0, 1, 0, 0, 1, 1, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 1, 1, 0, 1, 0, 0, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 1, 1, 1, 1, 0, 1, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 1, 1, 0, 1, 1, 1, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 1, 0, 0, 0, 0, 0, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 1, 0, 1, 0, 0, 1, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 1, 0, 0, 1, 0, 1, red, green, blue, alpha);
        stack.m_85849_();
    }

    static {
        for (int i = 0; i < POSITIONS.length; ++i) {
            DebugFrustumRenderer.POSITIONS[i] = new Vector3f();
        }
    }
}

