/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Map;

public class BlendState {
    public static final BlendState NONE = new BlendState(GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ZERO){

        @Override
        public void setup() {
            RenderSystem.disableBlend();
        }

        @Override
        public void clear() {
        }
    };
    public static final BlendState ADDITIVE = new BlendState(GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ONE);
    public static final BlendState LIGHTNING = new BlendState(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE);
    public static final BlendState GLINT = new BlendState(GlStateManager.SourceFactor.SRC_COLOR, GlStateManager.DestFactor.ONE, GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE);
    public static final BlendState CRUMBLING = new BlendState(GlStateManager.SourceFactor.DST_COLOR, GlStateManager.DestFactor.SRC_COLOR, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
    public static final BlendState TRANSLUCENT = new BlendState(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    private static final Map<String, BlendState> VANILLA_BLEND_STATES = Map.of("NONE", NONE, "ADDITIVE", ADDITIVE, "LIGHTNING", LIGHTNING, "GLINT", GLINT, "CRUMBLING", CRUMBLING, "TRANSLUCENT", TRANSLUCENT);
    private static final Codec<GlStateManager.SourceFactor> SOURCE_CODEC = Codec.STRING.comapFlatMap(name -> {
        for (GlStateManager.SourceFactor value : GlStateManager.SourceFactor.values()) {
            if (!name.equalsIgnoreCase(value.name())) continue;
            return DataResult.success((Object)value);
        }
        return DataResult.error(() -> "Unknown Source Factory: " + name);
    }, type -> type.name().toLowerCase(Locale.ROOT));
    private static final Codec<GlStateManager.DestFactor> DESTINATION_CODEC = Codec.STRING.comapFlatMap(name -> {
        for (GlStateManager.DestFactor value : GlStateManager.DestFactor.values()) {
            if (!name.equalsIgnoreCase(value.name())) continue;
            return DataResult.success((Object)value);
        }
        return DataResult.error(() -> "Unknown Destination Factory: " + name);
    }, type -> type.name().toLowerCase(Locale.ROOT));
    private static final Codec<BlendState> DEFAULT_CODEC = Codec.STRING.flatXmap(name -> {
        String key = name.toUpperCase(Locale.ROOT);
        BlendState state = VANILLA_BLEND_STATES.get(key);
        return state != null ? DataResult.success((Object)state) : DataResult.error(() -> "Unknown default blend state: " + key);
    }, state -> {
        for (Map.Entry<String, BlendState> entry : VANILLA_BLEND_STATES.entrySet()) {
            if (!entry.getValue().equals(state)) continue;
            return DataResult.success((Object)entry.getKey());
        }
        return DataResult.error(() -> "Unknown default blend state for: " + state);
    });
    private static final Codec<BlendState> COMPRESSED_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SOURCE_CODEC.fieldOf("src").forGetter(BlendState::src), (App)DESTINATION_CODEC.fieldOf("dest").forGetter(BlendState::dst)).apply((Applicative)instance, BlendState::new));
    private static final Codec<BlendState> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SOURCE_CODEC.fieldOf("src_color").forGetter(BlendState::src), (App)DESTINATION_CODEC.fieldOf("dest_color").forGetter(BlendState::dst), (App)SOURCE_CODEC.fieldOf("src_alpha").forGetter(BlendState::src), (App)DESTINATION_CODEC.fieldOf("dest_alpha").forGetter(BlendState::dst)).apply((Applicative)instance, BlendState::new));
    private static final Codec<BlendState> A = Codec.either(FULL_CODEC, COMPRESSED_CODEC).xmap(either -> (BlendState)either.map(s -> s, s -> s), state -> state.srcColor == state.srcAlpha && state.dstColor == state.dstAlpha ? Either.right((Object)state) : Either.left((Object)state));
    public static final Codec<BlendState> CODEC = Codec.either(FULL_CODEC, COMPRESSED_CODEC).xmap(either -> (BlendState)either.map(s -> s, s -> s), state -> state.srcColor == state.srcAlpha && state.dstColor == state.dstAlpha ? Either.right((Object)state) : Either.left((Object)state));
    private final GlStateManager.SourceFactor srcColor;
    private final GlStateManager.DestFactor dstColor;
    private final GlStateManager.SourceFactor srcAlpha;
    private final GlStateManager.DestFactor dstAlpha;

    public BlendState(GlStateManager.SourceFactor srcColor, GlStateManager.DestFactor dstColor, GlStateManager.SourceFactor srcAlpha, GlStateManager.DestFactor dstAlpha) {
        this.srcColor = srcColor;
        this.dstColor = dstColor;
        this.srcAlpha = srcAlpha;
        this.dstAlpha = dstAlpha;
    }

    public BlendState(GlStateManager.SourceFactor src, GlStateManager.DestFactor dst) {
        this(src, dst, src, dst);
    }

    public void setup() {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)this.srcColor, (GlStateManager.DestFactor)this.dstColor, (GlStateManager.SourceFactor)this.srcAlpha, (GlStateManager.DestFactor)this.dstAlpha);
    }

    public void clear() {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public GlStateManager.SourceFactor src() {
        return this.srcColor;
    }

    public GlStateManager.DestFactor dst() {
        return this.dstColor;
    }

    public GlStateManager.SourceFactor srcAlpha() {
        return this.srcAlpha;
    }

    public GlStateManager.DestFactor dstAlpha() {
        return this.dstAlpha;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlendState state = (BlendState)o;
        if (this.srcColor != state.srcColor) {
            return false;
        }
        if (this.dstColor != state.dstColor) {
            return false;
        }
        if (this.srcAlpha != state.srcAlpha) {
            return false;
        }
        return this.dstAlpha == state.dstAlpha;
    }

    public int hashCode() {
        int result = this.srcColor.hashCode();
        result = 31 * result + this.dstColor.hashCode();
        result = 31 * result + this.srcAlpha.hashCode();
        result = 31 * result + this.dstAlpha.hashCode();
        return result;
    }
}

