/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.graveyard.skeleton;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import foundry.veil.api.client.graveyard.AnimationProperties;
import foundry.veil.api.client.graveyard.constraint.Constraint;
import foundry.veil.api.client.graveyard.render.mesh.DynamicMesh;
import foundry.veil.api.client.graveyard.render.mesh.ModelMesh;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedBone;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedSkeletonParent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;

public abstract class InterpolatedSkeleton {
    private final List<InterpolatedBone> roots = new ArrayList<InterpolatedBone>();
    private final List<Constraint> constraints = new ArrayList<Constraint>();
    private final Map<String, InterpolatedBone> parts = new HashMap<String, InterpolatedBone>();
    private final Map<String, ModelMesh> meshes = new HashMap<String, ModelMesh>();
    private final Map<String, DynamicMesh> dynamicMeshes = new HashMap<String, DynamicMesh>();
    private int ticksExisted;

    protected void updatePreviousPosition() {
        for (InterpolatedBone part : this.parts.values()) {
            part.updatePreviousPosition();
        }
    }

    public void tick(AnimationProperties properties) {
        ++this.ticksExisted;
        this.updatePreviousPosition();
        for (InterpolatedBone part : this.parts.values()) {
            part.tick(0.05f);
        }
        this.animate(properties);
        for (Constraint constraint : this.constraints) {
            constraint.apply();
        }
    }

    public void addAnimationProperties(AnimationProperties properties, InterpolatedSkeletonParent parent) {
        if (parent instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)parent;
            properties.addProperty("entity", entity);
            properties.addProperty("limbSwing", entity.f_267362_.m_267756_());
            properties.addProperty("limbSwingAmount", entity.f_267362_.m_267731_());
            properties.addProperty("ageInTicks", entity.f_19797_);
            properties.addProperty("bodyYaw", 180.0f - entity.f_20883_);
            properties.addProperty("netHeadYaw", -(entity.f_20885_ - entity.f_20883_));
            properties.addProperty("headPitch", -entity.m_5686_(1.0f));
        }
    }

    public abstract void animate(AnimationProperties var1);

    public void render(PoseStack pPoseStack, VertexConsumer pVertexConsumer, int pPackedLight, int pPackedOverlay, float partialTicks, float pRed, float pGreen, float pBlue, float pAlpha) {
        for (Map.Entry<String, DynamicMesh> entry : this.dynamicMeshes.entrySet()) {
            entry.getValue().update(this.parts.get(entry.getKey()), this, this.ticksExisted, partialTicks);
        }
        for (InterpolatedBone part : this.roots) {
            part.render(this.meshes, partialTicks, pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha, true);
        }
    }

    public void renderDebug(InterpolatedSkeletonParent entity, PoseStack poseStack, MultiBufferSource buffer, float partialTicks) {
        for (Constraint constraint : this.constraints) {
            constraint.renderDebugInfo(this, entity, partialTicks, poseStack, buffer);
        }
    }

    public void addBone(InterpolatedBone part, ModelMesh mesh) {
        this.parts.put(part.identifier, part);
        this.meshes.put(part.identifier, mesh);
        if (mesh instanceof DynamicMesh) {
            DynamicMesh dynamicMesh = (DynamicMesh)((Object)mesh);
            this.dynamicMeshes.put(part.identifier, dynamicMesh);
        }
    }

    public void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
    }

    public void buildRoots() {
        for (InterpolatedBone part : this.parts.values()) {
            if (part.parent == null) {
                this.roots.add(part);
                continue;
            }
            InterpolatedBone parentBone = part.parent;
            while (parentBone != null) {
                part.parentChain.add(0, parentBone);
                parentBone = parentBone.parent;
            }
        }
    }
}

