/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.lib.abego.treelayout.util;

import foundry.veil.lib.abego.treelayout.internal.util.Contract;
import foundry.veil.lib.abego.treelayout.util.AbstractTreeForTreeLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreeForTreeLayout<TreeNode>
extends AbstractTreeForTreeLayout<TreeNode> {
    private List<TreeNode> emptyList;
    private Map<TreeNode, List<TreeNode>> childrenMap = new HashMap<TreeNode, List<TreeNode>>();
    private Map<TreeNode, TreeNode> parents = new HashMap<TreeNode, TreeNode>();

    private List<TreeNode> getEmptyList() {
        if (this.emptyList == null) {
            this.emptyList = new ArrayList<TreeNode>();
        }
        return this.emptyList;
    }

    public DefaultTreeForTreeLayout(TreeNode root) {
        super(root);
    }

    @Override
    public TreeNode getParent(TreeNode node) {
        return this.parents.get(node);
    }

    @Override
    public List<TreeNode> getChildrenList(TreeNode node) {
        List<TreeNode> result = this.childrenMap.get(node);
        return result == null ? this.getEmptyList() : result;
    }

    public boolean hasNode(TreeNode node) {
        return node == this.getRoot() || this.parents.containsKey(node);
    }

    public void addChild(TreeNode parentNode, TreeNode node) {
        Contract.checkArg(this.hasNode(parentNode), "parentNode is not in the tree");
        Contract.checkArg(!this.hasNode(node), "node is already in the tree");
        List<TreeNode> list = this.childrenMap.get(parentNode);
        if (list == null) {
            list = new ArrayList<TreeNode>();
            this.childrenMap.put(parentNode, list);
        }
        list.add(node);
        this.parents.put(node, parentNode);
    }

    public void addChildren(TreeNode parentNode, TreeNode ... nodes) {
        for (TreeNode node : nodes) {
            this.addChild(parentNode, node);
        }
    }
}

