/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.texture;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.shader.texture.ShaderTextureSource;
import net.minecraft.resources.ResourceLocation;

public record FramebufferSource(ResourceLocation name, int sampler, boolean depth) implements ShaderTextureSource
{
    public static final Codec<FramebufferSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(source -> source.name.toString()), (App)Codec.INT.optionalFieldOf("sampler", (Object)0).forGetter(FramebufferSource::sampler)).apply((Applicative)instance, (name, sampler) -> {
        boolean depth = name.endsWith(":depth");
        String path = depth ? name.substring(0, name.length() - 6) : name;
        ResourceLocation location = name.contains(":") ? new ResourceLocation(path) : new ResourceLocation("temp", name);
        return new FramebufferSource(location, depth ? 0 : sampler, depth);
    }));

    @Override
    public int getId(ShaderTextureSource.Context context) {
        AdvancedFbo framebuffer = context.getFramebuffer(this.name);
        if (framebuffer == null) {
            return 0;
        }
        if (this.depth) {
            return framebuffer.isDepthTextureAttachment() ? framebuffer.getDepthTextureAttachment().m_117963_() : 0;
        }
        return framebuffer.isColorTextureAttachment(this.sampler) ? framebuffer.getColorTextureAttachment(this.sampler).m_117963_() : 0;
    }

    @Override
    public ShaderTextureSource.Type getType() {
        return ShaderTextureSource.Type.FRAMEBUFFER;
    }
}

