/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource.editor;

import foundry.veil.Veil;
import foundry.veil.api.client.imgui.CodeEditor;
import foundry.veil.api.resource.VeilEditorEnvironment;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.api.resource.editor.ResourceFileEditor;
import foundry.veil.api.resource.type.VeilTextResource;
import imgui.ImGui;
import imgui.extension.texteditor.TextEditor;
import imgui.extension.texteditor.TextEditorLanguageDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class TextFileEditor
implements ResourceFileEditor<VeilTextResource<?>> {
    private static final Component SAVE = Component.m_237115_((String)"gui.veil.save");
    private final CodeEditor editor = new CodeEditor(SAVE);

    @Override
    public void render() {
        this.editor.renderWindow();
        if (ImGui.beginPopupModal((String)"###open_failed")) {
            ImGui.text((String)"Failed to open file");
            ImGui.endPopup();
        }
    }

    @Override
    public void open(VeilEditorEnvironment environment, VeilTextResource<?> resource) {
        VeilResourceInfo info = resource.resourceInfo();
        TextEditorLanguageDefinition languageDefinition = resource.languageDefinition();
        VeilResourceManager resourceManager = environment.getResourceManager();
        this.editor.show(info.fileName(), "");
        this.editor.setSaveCallback(null);
        this.editor.getEditor().setReadOnly(true);
        this.editor.getEditor().setColorizerEnable(false);
        resourceManager.resources(info).m_213713_(info.location()).ifPresentOrElse(data -> CompletableFuture.supplyAsync(() -> {
            String string;
            block8: {
                InputStream stream = data.m_215507_();
                try {
                    string = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new CompletionException(e);
                    }
                }
                stream.close();
            }
            return string;
        }, Util.m_183992_()).handleAsync((contents, error) -> {
            if (error != null) {
                this.editor.hide();
                ImGui.openPopup((String)"###open_failed");
                Veil.LOGGER.error("Failed to open file", error);
                return null;
            }
            this.editor.show(info.fileName(), (String)contents);
            this.editor.setSaveCallback((source, errorConsumer) -> this.save(source.getBytes(StandardCharsets.UTF_8), resource));
            TextEditor textEditor = this.editor.getEditor();
            textEditor.setReadOnly(resource.resourceInfo().isStatic());
            if (languageDefinition != null) {
                textEditor.setColorizerEnable(true);
                textEditor.setLanguageDefinition(languageDefinition);
            }
            return null;
        }, (Executor)Minecraft.m_91087_()), () -> {
            this.editor.hide();
            ImGui.openPopup((String)"###open_failed");
        });
    }
}

