/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_preprocessor.fs;

import io.github.douira.glsl_preprocessor.fs.StringFile;
import io.github.douira.glsl_preprocessor.fs.VirtualFile;
import io.github.douira.glsl_preprocessor.fs.VirtualFileSystem;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MemoryFileSystem
implements VirtualFileSystem {
    private final Map<String, VirtualFile> files = new HashMap<String, VirtualFile>();

    public MemoryFileSystem() {
    }

    public MemoryFileSystem(Map<String, VirtualFile> files) {
        this.files.putAll(files);
    }

    public void addFile(String path, VirtualFile file) {
        this.files.put(path, file);
    }

    public void addFile(String path, String content) {
        this.addFile(path, new StringFile(content));
    }

    @Override
    public VirtualFile getFile(String path) {
        if (!this.files.containsKey(path)) {
            throw new RuntimeException(new IOException("File not found: " + path));
        }
        return this.files.get(path);
    }
}

