/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_preprocessor;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.github.douira.glsl_preprocessor.Preprocessor;
import io.github.douira.glsl_preprocessor.Token;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class Argument
extends ArrayList<Token> {
    private List<Token> expansion = null;

    public void addToken(@NonNull Token tok) {
        this.add(tok);
    }

    void expand(@NonNull Preprocessor p) {
        if (this.expansion == null) {
            this.expansion = p.expand(this);
        }
    }

    @NonNull
    public Iterator<Token> expansion() {
        return this.expansion.iterator();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Argument(");
        buf.append("raw=[ ");
        for (int i = 0; i < this.size(); ++i) {
            buf.append(((Token)this.get(i)).getText());
        }
        buf.append(" ];expansion=[ ");
        if (this.expansion == null) {
            buf.append("null");
        } else {
            for (Token token : this.expansion) {
                buf.append(token.getText());
            }
        }
        buf.append(" ])");
        return buf.toString();
    }
}

