/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.emitters.module.render;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.VeilDeferredRenderer;
import foundry.veil.api.client.render.deferred.light.PointLight;
import foundry.veil.api.quasar.emitters.module.RenderParticleModule;
import foundry.veil.api.quasar.emitters.module.UpdateParticleModule;
import foundry.veil.api.quasar.particle.QuasarParticle;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class CustomLightModule
implements UpdateParticleModule,
RenderParticleModule {
    private final Vector4f lastColor = new Vector4f(1.0f);
    private final Vector4f color = new Vector4f(1.0f);
    private final Vector4f renderColor = new Vector4f(1.0f);
    private float brightness;
    private float radius;
    private PointLight light = null;
    private boolean enabled;

    @Override
    public void update(QuasarParticle particle) {
        VeilDeferredRenderer deferredRenderer = VeilRenderSystem.renderer().getDeferredRenderer();
        this.enabled = deferredRenderer.isEnabled();
        if (!this.enabled) {
            this.onRemove();
            return;
        }
        this.lastColor.set((Vector4fc)this.color);
        float brightness = this.brightness * this.color.w;
        if ((double)this.color.lengthSquared() < 0.1 && (double)brightness < 0.1) {
            this.onRemove();
        } else {
            if (this.light == null) {
                this.light = new PointLight().setRadius(this.radius);
                deferredRenderer.getLightRenderer().addLight(this.light);
            }
            this.light.setColor(this.color.x, this.color.y, this.color.z);
            this.light.setBrightness(this.brightness * this.color.w);
        }
    }

    @Override
    public void render(QuasarParticle particle, float partialTicks) {
        if (this.light == null) {
            return;
        }
        this.light.setPosition(particle.getRenderData().getRenderPosition());
        this.lastColor.lerp((Vector4fc)this.color, partialTicks, this.renderColor);
        this.light.setColor(this.renderColor.x, this.renderColor.y, this.renderColor.z);
        this.light.setBrightness(this.brightness * this.renderColor.w);
    }

    @Override
    public void onRemove() {
        if (this.light != null) {
            VeilDeferredRenderer deferredRenderer = VeilRenderSystem.renderer().getDeferredRenderer();
            if (deferredRenderer.isEnabled()) {
                deferredRenderer.getLightRenderer().removeLight(this.light);
            }
            this.light = null;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled || VeilRenderSystem.renderer().getDeferredRenderer().isEnabled();
    }

    public Vector4f getColor() {
        return this.color;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }
}

