/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DebugRenderHelper {
    public static void renderCube(PoseStack pPoseStack, VertexConsumer pConsumer, float pRed, float pGreen, float pBlue, float pAlpha) {
        DebugRenderHelper.renderBox(pPoseStack, pConsumer, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, pRed, pGreen, pBlue, pAlpha);
    }

    public static void renderBox(PoseStack pPoseStack, VertexConsumer pConsumer, double pMinX, double pMinY, double pMinZ, double pMaxX, double pMaxY, double pMaxZ, float pRed, float pGreen, float pBlue, float pAlpha) {
        Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = pPoseStack.m_85850_().m_252943_();
        float iX = (float)pMinX;
        float iY = (float)pMinY;
        float iZ = (float)pMinZ;
        float aX = (float)pMaxX;
        float aY = (float)pMaxY;
        float aZ = (float)pMaxZ;
        pConsumer.m_252986_(matrix4f, iX, iY, iZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, aX, iY, iZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, iX, iY, iZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, iX, aY, iZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, iX, iY, iZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, iX, iY, aZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, aX, iY, iZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, aX, aY, iZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, aX, aY, iZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, iX, aY, iZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, iX, aY, iZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, iX, aY, aZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, iX, aY, aZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, iX, iY, aZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, iX, iY, aZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, aX, iY, aZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, aX, iY, aZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, aX, iY, iZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, iX, aY, aZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, aX, aY, aZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, aX, iY, aZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, aX, aY, aZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, aX, aY, iZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        pConsumer.m_252986_(matrix4f, aX, aY, aZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    public static void renderBox(PoseStack pPoseStack, VertexConsumer pConsumer, AABB box, float pRed, float pGreen, float pBlue, float pAlpha) {
        DebugRenderHelper.renderBox(pPoseStack, pConsumer, box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_, pRed, pGreen, pBlue, pAlpha);
    }

    public static void renderSphere(PoseStack pPoseStack, VertexConsumer pConsumer, int resolution, float radius, double x, double y, double z, float pRed, float pGreen, float pBlue, float pAlpha) {
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(x, y, z);
        for (int i = 0; i < 3; ++i) {
            pPoseStack.m_85836_();
            switch (i) {
                case 1: {
                    pPoseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                    break;
                }
                case 2: {
                    pPoseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                }
            }
            Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
            Matrix3f matrix3f = pPoseStack.m_85850_().m_252943_();
            pPoseStack.m_85849_();
            for (int segment = 0; segment < resolution; ++segment) {
                float angle1 = (float)segment / (float)resolution * ((float)Math.PI * 2);
                float angle2 = (float)(segment + 1) / (float)resolution * ((float)Math.PI * 2);
                float s1 = Mth.m_14031_((float)angle1) * radius;
                float c1 = Mth.m_14089_((float)angle1) * radius;
                float s2 = Mth.m_14031_((float)angle2) * radius;
                float c2 = Mth.m_14089_((float)angle2) * radius;
                Vector3f normal = new Vector3f(s1, 0.0f, c1);
                normal.sub((Vector3fc)new Vector3f(s2, 0.0f, c2));
                normal.normalize();
                DebugRenderHelper.renderLine(matrix4f, matrix3f, pConsumer, s1, c1, 0.0f, s2, c2, 0.0f, pRed, pGreen, pBlue, pAlpha);
            }
        }
        pPoseStack.m_85849_();
    }

    public static void renderCircle(PoseStack pPoseStack, VertexConsumer pConsumer, int resolution, float radius, double x, double y, double z, float pRed, float pGreen, float pBlue, float pAlpha) {
        Minecraft mc = Minecraft.m_91087_();
        Camera pRenderInfo = mc.f_91063_.m_109153_();
        Quaternionf rotation = pRenderInfo.m_253121_();
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(x, y, z);
        pPoseStack.m_252781_(rotation);
        Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = pPoseStack.m_85850_().m_252943_();
        for (int segment = 0; segment < resolution; ++segment) {
            float angle1 = (float)segment / (float)resolution * ((float)Math.PI * 2);
            float angle2 = (float)(segment + 1) / (float)resolution * ((float)Math.PI * 2);
            float s1 = Mth.m_14031_((float)angle1) * radius;
            float c1 = Mth.m_14089_((float)angle1) * radius;
            float s2 = Mth.m_14031_((float)angle2) * radius;
            float c2 = Mth.m_14089_((float)angle2) * radius;
            Vector3f normal = new Vector3f(s1, 0.0f, c1);
            normal.sub((Vector3fc)new Vector3f(s2, 0.0f, c2));
            normal.normalize();
            DebugRenderHelper.renderLine(matrix4f, matrix3f, pConsumer, s1, c1, 0.0f, s2, c2, 0.0f, pRed, pGreen, pBlue, pAlpha);
        }
        pPoseStack.m_85849_();
    }

    public static void renderLine(PoseStack pPoseStack, VertexConsumer pConsumer, double pMinX, double pMinY, double pMinZ, double pMaxX, double pMaxY, double pMaxZ, float pRed, float pGreen, float pBlue, float pAlpha) {
        Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = pPoseStack.m_85850_().m_252943_();
        float minX = (float)pMinX;
        float minY = (float)pMinY;
        float minZ = (float)pMinZ;
        float maxX = (float)pMaxX;
        float maxY = (float)pMaxY;
        float maxZ = (float)pMaxZ;
        Vector3f normal = new Vector3f(minX, minY, minZ);
        normal.sub((Vector3fc)new Vector3f(maxX, maxY, maxZ));
        normal.normalize();
        pConsumer.m_252986_(matrix4f, minX, minY, minZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, normal.x(), normal.y(), normal.z()).m_5752_();
        pConsumer.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, normal.x(), normal.y(), normal.z()).m_5752_();
    }

    public static void renderLine(PoseStack pPoseStack, VertexConsumer pConsumer, double pMinX, double pMinY, double pMinZ, double pMaxX, double pMaxY, double pMaxZ, float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2) {
        Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = pPoseStack.m_85850_().m_252943_();
        float minX = (float)pMinX;
        float minY = (float)pMinY;
        float minZ = (float)pMinZ;
        float maxX = (float)pMaxX;
        float maxY = (float)pMaxY;
        float maxZ = (float)pMaxZ;
        Vector3f normal = new Vector3f(minX, minY, minZ);
        normal.sub((Vector3fc)new Vector3f(maxX, maxY, maxZ));
        normal.normalize();
        pConsumer.m_252986_(matrix4f, minX, minY, minZ).m_85950_(r1, g1, b1, a1).m_252939_(matrix3f, normal.x(), normal.y(), normal.z()).m_5752_();
        pConsumer.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(r2, g2, b2, a2).m_252939_(matrix3f, normal.x(), normal.y(), normal.z()).m_5752_();
    }

    public static void renderLine(Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer pConsumer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float pRed, float pGreen, float pBlue, float pAlpha) {
        Vector3f normal = new Vector3f(minX, minY, minZ);
        normal.sub((Vector3fc)new Vector3f(maxX, maxY, maxZ));
        normal.normalize();
        pConsumer.m_252986_(matrix4f, minX, minY, minZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, normal.x(), normal.y(), normal.z()).m_5752_();
        pConsumer.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(matrix3f, normal.x(), normal.y(), normal.z()).m_5752_();
    }
}

