/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_preprocessor;

import io.github.douira.glsl_preprocessor.Source;
import io.github.douira.glsl_preprocessor.Token;
import java.util.Arrays;
import java.util.List;

class FixedTokenSource
extends Source {
    private static final Token EOF = new Token(265, "<ts-eof>");
    private final List<Token> tokens;
    private int idx;

    FixedTokenSource(Token ... tokens) {
        this.tokens = Arrays.asList(tokens);
        this.idx = 0;
    }

    FixedTokenSource(List<Token> tokens) {
        this.tokens = tokens;
        this.idx = 0;
    }

    @Override
    public Token token() {
        if (this.idx >= this.tokens.size()) {
            return EOF;
        }
        return this.tokens.get(this.idx++);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("constant token stream ").append(this.tokens);
        Source parent = this.getParent();
        if (parent != null) {
            buf.append(" in ").append(String.valueOf(parent));
        }
        return buf.toString();
    }
}

