/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.lib.opencl;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct cl_image_format")
public class CLImageFormat
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IMAGE_CHANNEL_ORDER;
    public static final int IMAGE_CHANNEL_DATA_TYPE;

    public CLImageFormat(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CLImageFormat.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="cl_channel_order")
    public int image_channel_order() {
        return CLImageFormat.nimage_channel_order(this.address());
    }

    @NativeType(value="cl_channel_type")
    public int image_channel_data_type() {
        return CLImageFormat.nimage_channel_data_type(this.address());
    }

    public CLImageFormat image_channel_order(@NativeType(value="cl_channel_order") int value) {
        CLImageFormat.nimage_channel_order(this.address(), value);
        return this;
    }

    public CLImageFormat image_channel_data_type(@NativeType(value="cl_channel_type") int value) {
        CLImageFormat.nimage_channel_data_type(this.address(), value);
        return this;
    }

    public CLImageFormat set(int image_channel_order, int image_channel_data_type) {
        this.image_channel_order(image_channel_order);
        this.image_channel_data_type(image_channel_data_type);
        return this;
    }

    public CLImageFormat set(CLImageFormat src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CLImageFormat malloc() {
        return CLImageFormat.wrap(CLImageFormat.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CLImageFormat calloc() {
        return CLImageFormat.wrap(CLImageFormat.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CLImageFormat create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CLImageFormat.wrap(CLImageFormat.class, MemoryUtil.memAddress(container), container);
    }

    public static CLImageFormat create(long address) {
        return CLImageFormat.wrap(CLImageFormat.class, address);
    }

    @Nullable
    public static CLImageFormat createSafe(long address) {
        return address == 0L ? null : CLImageFormat.wrap(CLImageFormat.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CLImageFormat.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CLImageFormat.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CLImageFormat.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CLImageFormat.__create(capacity, SIZEOF);
        return CLImageFormat.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CLImageFormat.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CLImageFormat.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CLImageFormat mallocStack() {
        return CLImageFormat.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CLImageFormat callocStack() {
        return CLImageFormat.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CLImageFormat mallocStack(MemoryStack stack) {
        return CLImageFormat.malloc(stack);
    }

    @Deprecated
    public static CLImageFormat callocStack(MemoryStack stack) {
        return CLImageFormat.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CLImageFormat.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CLImageFormat.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CLImageFormat.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CLImageFormat.calloc(capacity, stack);
    }

    public static CLImageFormat malloc(MemoryStack stack) {
        return CLImageFormat.wrap(CLImageFormat.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CLImageFormat calloc(MemoryStack stack) {
        return CLImageFormat.wrap(CLImageFormat.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CLImageFormat.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CLImageFormat.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nimage_channel_order(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMAGE_CHANNEL_ORDER);
    }

    public static int nimage_channel_data_type(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMAGE_CHANNEL_DATA_TYPE);
    }

    public static void nimage_channel_order(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IMAGE_CHANNEL_ORDER, value);
    }

    public static void nimage_channel_data_type(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IMAGE_CHANNEL_DATA_TYPE, value);
    }

    static {
        Struct.Layout layout = CLImageFormat.__struct(CLImageFormat.__member(4), CLImageFormat.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IMAGE_CHANNEL_ORDER = layout.offsetof(0);
        IMAGE_CHANNEL_DATA_TYPE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CLImageFormat, Buffer>
    implements NativeResource {
        private static final CLImageFormat ELEMENT_FACTORY = CLImageFormat.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CLImageFormat getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="cl_channel_order")
        public int image_channel_order() {
            return CLImageFormat.nimage_channel_order(this.address());
        }

        @NativeType(value="cl_channel_type")
        public int image_channel_data_type() {
            return CLImageFormat.nimage_channel_data_type(this.address());
        }

        public Buffer image_channel_order(@NativeType(value="cl_channel_order") int value) {
            CLImageFormat.nimage_channel_order(this.address(), value);
            return this;
        }

        public Buffer image_channel_data_type(@NativeType(value="cl_channel_type") int value) {
            CLImageFormat.nimage_channel_data_type(this.address(), value);
            return this;
        }
    }
}

