/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.lib.ibm.icu.text;

import foundry.veil.lib.ibm.icu.text.Replaceable;
import foundry.veil.lib.ibm.icu.text.Transliterator;
import foundry.veil.lib.ibm.icu.text.UnicodeReplacer;
import foundry.veil.lib.ibm.icu.text.UnicodeSet;

class FunctionReplacer
implements UnicodeReplacer {
    private Transliterator translit;
    private UnicodeReplacer replacer;

    public FunctionReplacer(Transliterator theTranslit, UnicodeReplacer theReplacer) {
        this.translit = theTranslit;
        this.replacer = theReplacer;
    }

    @Override
    public int replace(Replaceable text, int start, int limit, int[] cursor) {
        int len = this.replacer.replace(text, start, limit, cursor);
        limit = start + len;
        limit = this.translit.transliterate(text, start, limit);
        return limit - start;
    }

    @Override
    public String toReplacerPattern(boolean escapeUnprintable) {
        StringBuilder rule = new StringBuilder("&");
        rule.append(this.translit.getID());
        rule.append("( ");
        rule.append(this.replacer.toReplacerPattern(escapeUnprintable));
        rule.append(" )");
        return rule.toString();
    }

    @Override
    public void addReplacementSetTo(UnicodeSet toUnionTo) {
        toUnionTo.addAll(this.translit.getTargetSet());
    }
}

