/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.lib.antlr.v4.gui;

import foundry.veil.lib.abego.treelayout.TreeForTreeLayout;
import foundry.veil.lib.antlr.v4.runtime.tree.Tree;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TreeLayoutAdaptor
implements TreeForTreeLayout<Tree> {
    private Tree root;

    public TreeLayoutAdaptor(Tree root) {
        this.root = root;
    }

    @Override
    public boolean isLeaf(Tree node) {
        return node.getChildCount() == 0;
    }

    @Override
    public boolean isChildOfParent(Tree node, Tree parentNode) {
        return node.getParent() == parentNode;
    }

    @Override
    public Tree getRoot() {
        return this.root;
    }

    @Override
    public Tree getLastChild(Tree parentNode) {
        return parentNode.getChild(parentNode.getChildCount() - 1);
    }

    @Override
    public Tree getFirstChild(Tree parentNode) {
        return parentNode.getChild(0);
    }

    @Override
    public Iterable<Tree> getChildrenReverse(Tree node) {
        return new AntlrTreeChildrenReverseIterable(node);
    }

    @Override
    public Iterable<Tree> getChildren(Tree node) {
        return new AntlrTreeChildrenIterable(node);
    }

    private static class AntlrTreeChildrenReverseIterable
    implements Iterable<Tree> {
        private final Tree tree;

        public AntlrTreeChildrenReverseIterable(Tree tree) {
            this.tree = tree;
        }

        @Override
        public Iterator<Tree> iterator() {
            return new Iterator<Tree>(){
                private int i;
                {
                    this.i = tree.getChildCount();
                }

                @Override
                public boolean hasNext() {
                    return this.i > 0;
                }

                @Override
                public Tree next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return tree.getChild(--this.i);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class AntlrTreeChildrenIterable
    implements Iterable<Tree> {
        private final Tree tree;

        public AntlrTreeChildrenIterable(Tree tree) {
            this.tree = tree;
        }

        @Override
        public Iterator<Tree> iterator() {
            return new Iterator<Tree>(){
                private int i = 0;

                @Override
                public boolean hasNext() {
                    return tree.getChildCount() > this.i;
                }

                @Override
                public Tree next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return tree.getChild(this.i++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

