/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.client.render.post.PostProcessingManager;
import foundry.veil.api.client.render.shader.ShaderCompiler;
import foundry.veil.api.client.render.shader.ShaderException;
import foundry.veil.api.client.render.shader.ShaderSourceSet;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import foundry.veil.api.client.render.shader.processor.ShaderCPreprocessor;
import foundry.veil.api.client.render.shader.processor.ShaderCustomProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderModifyProcessor;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

public class ShaderManager
implements PreparableReloadListener,
Closeable {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(ProgramDefinition.class, (Object)new ProgramDefinition.Deserializer()).create();
    public static final FileToIdConverter INCLUDE_LISTER = new FileToIdConverter("pinwheel/shaders/include", ".glsl");
    public static final ShaderSourceSet PROGRAM_SET = new ShaderSourceSet("pinwheel/shaders/program");
    public static final ShaderSourceSet DEFERRED_SET = new ShaderSourceSet("pinwheel/shaders/deferred");
    private static final Map<Integer, String> TYPES = Map.of(35633, "vertex", 36488, "tesselation_control", 36487, "tesselation_evaluation", 36313, "geometry", 35632, "fragment", 37305, "compute");
    private final ShaderSourceSet sourceSet;
    private final ShaderPreDefinitions definitions;
    private final Map<ResourceLocation, ShaderProgram> shaders;
    private final Map<ResourceLocation, ShaderProgram> shadersView;
    private final Set<ResourceLocation> dirtyShaders;
    private CompletableFuture<Void> reloadFuture;
    private CompletableFuture<Void> recompileFuture;

    public ShaderManager(ShaderSourceSet sourceSet, ShaderPreDefinitions shaderPreDefinitions) {
        this.sourceSet = sourceSet;
        this.definitions = shaderPreDefinitions;
        this.definitions.addListener(this::onDefinitionChanged);
        this.shaders = new HashMap<ResourceLocation, ShaderProgram>();
        this.shadersView = Collections.unmodifiableMap(this.shaders);
        this.dirtyShaders = new HashSet<ResourceLocation>();
        this.reloadFuture = CompletableFuture.completedFuture(null);
        this.recompileFuture = CompletableFuture.completedFuture(null);
    }

    private void onDefinitionChanged(String definition) {
        this.shaders.values().forEach(shader -> {
            if (shader.getDefinitionDependencies().contains(definition)) {
                Veil.LOGGER.debug("{} changed, recompiling {}", (Object)definition, (Object)shader.getId());
                this.scheduleRecompile(shader.getId());
            }
        });
    }

    private ProgramDefinition parseDefinition(ResourceLocation id, ResourceProvider provider) throws IOException {
        ProgramDefinition programDefinition;
        block9: {
            BufferedReader reader = provider.m_215597_(this.sourceSet.getShaderDefinitionLister().m_245698_(id));
            try {
                ProgramDefinition definition = (ProgramDefinition)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, ProgramDefinition.class);
                if (definition.vertex() == null && definition.tesselationControl() == null && definition.tesselationEvaluation() == null && definition.geometry() == null && definition.fragment() == null && definition.compute() == null) {
                    throw new JsonSyntaxException("Shader programs must define at least 1 shader type");
                }
                programDefinition = definition;
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException e) {
                    throw new IOException(e);
                }
            }
            ((Reader)reader).close();
        }
        return programDefinition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readShader(ResourceManager resourceManager, Map<ResourceLocation, ProgramDefinition> definitions, Map<ResourceLocation, Resource> shaderSources, ResourceLocation id) {
        HashSet<ResourceLocation> checkedSources = new HashSet<ResourceLocation>();
        try {
            ProgramDefinition definition = this.parseDefinition(id, (ResourceProvider)resourceManager);
            if (definitions.put(id, definition) != null) {
                throw new IllegalStateException("Duplicate shader ignored with ID " + id);
            }
            for (Int2ObjectMap.Entry shader : definition.shaders().int2ObjectEntrySet()) {
                FileToIdConverter typeConverter = this.sourceSet.getTypeConverter(shader.getIntKey());
                ResourceLocation location = typeConverter.m_245698_(((ProgramDefinition.ShaderSource)shader.getValue()).location());
                if (!checkedSources.add(location)) continue;
                Resource resource = resourceManager.m_215593_(location);
                try {
                    InputStream stream = resource.m_215507_();
                    try {
                        byte[] source = stream.readAllBytes();
                        Resource fileResource = new Resource(resource.m_247173_(), () -> new ByteArrayInputStream(source));
                        shaderSources.put(location, fileResource);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Throwable t) {
                    throw new IOException("Failed to load " + ShaderManager.getTypeName(shader.getIntKey()) + " shader", t);
                    return;
                }
            }
        }
        catch (JsonParseException | IOException | IllegalArgumentException e) {
            Veil.LOGGER.error("Couldn't parse shader {} from {}", new Object[]{id, this.sourceSet.getShaderDefinitionLister().m_245698_(id), e});
        }
    }

    private Map<ResourceLocation, Resource> readIncludes(ResourceManager resourceManager) {
        HashMap<ResourceLocation, Resource> shaderSources = new HashMap<ResourceLocation, Resource>();
        HashSet<ResourceLocation> checkedSources = new HashSet<ResourceLocation>();
        for (Map.Entry entry : INCLUDE_LISTER.m_247457_(resourceManager).entrySet()) {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            ResourceLocation id = INCLUDE_LISTER.m_245273_(location);
            if (!checkedSources.add(location)) continue;
            try {
                Resource resource = resourceManager.m_215593_(location);
                InputStream stream = resource.m_215507_();
                try {
                    byte[] source = stream.readAllBytes();
                    Resource fileResource = new Resource(resource.m_247173_(), () -> new ByteArrayInputStream(source));
                    shaderSources.put(location, fileResource);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException e) {
                Veil.LOGGER.error("Couldn't parse shader import {} from {}", new Object[]{id, location, e});
            }
        }
        return shaderSources;
    }

    private void compile(ShaderProgram program, ProgramDefinition definition, ShaderCompiler compiler) {
        ResourceLocation id = program.getId();
        try {
            program.compile(new ShaderCompiler.Context(this.definitions, this.sourceSet, definition), compiler);
        }
        catch (ShaderException e) {
            Veil.LOGGER.error("Failed to create shader {}: {}", (Object)id, (Object)e.getMessage());
            String error = e.getGlError();
            if (error != null) {
                Veil.LOGGER.warn(error);
            }
        }
        catch (Exception e) {
            Veil.LOGGER.error("Failed to create shader: {}", (Object)id, (Object)e);
        }
    }

    private ShaderCompiler addProcessors(ShaderCompiler compiler, ResourceProvider provider) {
        return compiler.addDefaultProcessors().addPreprocessor(new ShaderCPreprocessor(), false).addPreprocessor(new ShaderModifyProcessor(), false).addPreprocessor(new ShaderCustomProcessor(provider), false).addPreprocessor(new ShaderCPreprocessor(), false);
    }

    public void recompile(ResourceLocation id, ResourceProvider provider) {
        try (ShaderCompiler compiler = this.addProcessors(ShaderCompiler.direct(provider), provider);){
            this.recompile(id, provider, compiler);
        }
    }

    public void recompile(ResourceLocation id, ResourceProvider provider, ShaderCompiler compiler) {
        ShaderProgram program = this.shaders.get(id);
        if (program == null) {
            Veil.LOGGER.error("Failed to recompile unknown shader: {}", (Object)id);
            return;
        }
        try {
            this.compile(program, this.parseDefinition(id, provider), compiler);
        }
        catch (Exception e) {
            Veil.LOGGER.error("Failed to read shader definition: {}", (Object)id, (Object)e);
        }
    }

    public void setGlobal(Consumer<ShaderProgram> setter) {
        this.shaders.values().forEach(setter);
    }

    @Nullable
    public ShaderProgram getShader(ResourceLocation id) {
        return this.shaders.get(id);
    }

    public Map<ResourceLocation, ShaderProgram> getShaders() {
        return this.shadersView;
    }

    public ShaderSourceSet getSourceSet() {
        return this.sourceSet;
    }

    private ReloadState prepare(ResourceManager resourceManager, Collection<ResourceLocation> shaders) {
        HashMap<ResourceLocation, ProgramDefinition> definitions = new HashMap<ResourceLocation, ProgramDefinition>();
        HashMap<ResourceLocation, Resource> shaderSources = new HashMap<ResourceLocation, Resource>();
        for (ResourceLocation key : shaders) {
            this.readShader(resourceManager, definitions, shaderSources, key);
        }
        shaderSources.putAll(this.readIncludes(resourceManager));
        return new ReloadState(definitions, shaderSources);
    }

    private void apply(ReloadState reloadState) {
        this.shaders.values().forEach(NativeResource::free);
        this.shaders.clear();
        ResourceProvider sourceProvider = loc -> Optional.ofNullable(reloadState.shaderSources().get(loc));
        try (ShaderCompiler compiler = this.addProcessors(ShaderCompiler.cached(sourceProvider), sourceProvider);){
            for (Map.Entry<ResourceLocation, ProgramDefinition> entry : reloadState.definitions().entrySet()) {
                ResourceLocation id = entry.getKey();
                ShaderProgram program = ShaderProgram.create(id);
                this.compile(program, entry.getValue(), compiler);
                this.shaders.put(id, program);
            }
        }
        VeilRenderSystem.finalizeShaderCompilation();
        Veil.LOGGER.info("Loaded {} shaders from: {}", (Object)this.shaders.size(), (Object)this.sourceSet.getFolder());
    }

    private void applyRecompile(ReloadState reloadState, Collection<ResourceLocation> shaders) {
        ResourceProvider sourceProvider = loc -> Optional.ofNullable(reloadState.shaderSources().get(loc));
        try (ShaderCompiler compiler = this.addProcessors(ShaderCompiler.cached(sourceProvider), sourceProvider);){
            for (Map.Entry<ResourceLocation, ProgramDefinition> entry : reloadState.definitions().entrySet()) {
                ResourceLocation id = entry.getKey();
                ShaderProgram program = this.getShader(id);
                if (program == null) {
                    Veil.LOGGER.warn("Failed to recompile shader: {}", (Object)id);
                    continue;
                }
                this.compile(program, entry.getValue(), compiler);
            }
        }
        VeilRenderSystem.finalizeShaderCompilation();
        Veil.LOGGER.info("Recompiled {} shaders from: {}", (Object)shaders.size(), (Object)this.sourceSet.getFolder());
    }

    private void scheduleRecompile(int attempt) {
        Minecraft client = Minecraft.m_91087_();
        client.m_6937_(() -> {
            HashSet<ResourceLocation> shaders;
            if (!this.recompileFuture.isDone()) {
                return;
            }
            Set<ResourceLocation> set = this.dirtyShaders;
            synchronized (set) {
                shaders = new HashSet<ResourceLocation>(this.dirtyShaders);
                this.dirtyShaders.clear();
            }
            this.recompileFuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.prepare(client.m_91098_(), shaders), Util.m_183991_()).thenAcceptAsync(state -> this.applyRecompile((ReloadState)state, (Collection<ResourceLocation>)shaders), (Executor)client)).handle((value, e) -> {
                if (e != null) {
                    Veil.LOGGER.error("Error recompiling shaders", e);
                }
                Set<ResourceLocation> set = this.dirtyShaders;
                synchronized (set) {
                    if (this.dirtyShaders.isEmpty()) {
                        return value;
                    }
                }
                if (attempt >= 3) {
                    Veil.LOGGER.error("Failed to recompile shaders after {} attempts", (Object)attempt);
                    return value;
                }
                this.scheduleRecompile(attempt + 1);
                return value;
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleRecompile(ResourceLocation shader) {
        Set<ResourceLocation> set = this.dirtyShaders;
        synchronized (set) {
            this.dirtyShaders.add(shader);
        }
        if (!this.recompileFuture.isDone()) {
            return;
        }
        this.scheduleRecompile(0);
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        if (this.reloadFuture != null && !this.reloadFuture.isDone()) {
            return this.reloadFuture.thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).m_6769_(arg_0));
        }
        this.reloadFuture = this.recompileFuture.thenCompose(unused -> ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            FileToIdConverter lister = this.sourceSet.getShaderDefinitionLister();
            Set<ResourceLocation> shaderIds = lister.m_247457_(resourceManager).keySet().stream().map(arg_0 -> ((FileToIdConverter)lister).m_245273_(arg_0)).collect(Collectors.toSet());
            return this.prepare(resourceManager, shaderIds);
        }, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).m_6769_(arg_0))).thenAcceptAsync(this::apply, gameExecutor));
        return this.reloadFuture;
    }

    public String m_7812_() {
        return this.getClass().getSimpleName() + " " + this.getSourceSet().getFolder();
    }

    public CompletableFuture<Void> reload(ResourceManager resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
        VeilRenderer renderer = VeilRenderSystem.renderer();
        FramebufferManager framebufferManager = renderer.getFramebufferManager();
        PostProcessingManager postProcessingManager = renderer.getPostProcessingManager();
        this.reloadFuture = CompletableFuture.allOf(this.reload(this, resourceManager, backgroundExecutor, gameExecutor), this.reload((PreparableReloadListener)framebufferManager, resourceManager, backgroundExecutor, gameExecutor), this.reload((PreparableReloadListener)postProcessingManager, resourceManager, backgroundExecutor, gameExecutor));
        return this.reloadFuture;
    }

    private CompletableFuture<Void> reload(PreparableReloadListener listener, ResourceManager resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
        return listener.m_5540_(CompletableFuture::completedFuture, resourceManager, (ProfilerFiller)InactiveProfiler.f_18554_, (ProfilerFiller)InactiveProfiler.f_18554_, backgroundExecutor, gameExecutor);
    }

    public CompletableFuture<Void> getReloadFuture() {
        return this.reloadFuture;
    }

    public CompletableFuture<Void> getRecompileFuture() {
        return this.recompileFuture;
    }

    public static String getTypeName(int type) {
        String value = TYPES.get(type);
        return value != null ? value : "0x" + Integer.toHexString(type);
    }

    @Override
    public void close() {
        this.shaders.values().forEach(NativeResource::free);
        this.shaders.clear();
    }

    private record ReloadState(Map<ResourceLocation, ProgramDefinition> definitions, Map<ResourceLocation, Resource> shaderSources) {
    }
}

