/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.framebuffer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFboAttachment;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class AdvancedFboTextureAttachment
extends AbstractTexture
implements AdvancedFboAttachment {
    private final int attachmentType;
    private final int format;
    private final int texelFormat;
    private final int dataType;
    private final int width;
    private final int height;
    private final int mipmapLevels;
    private final boolean linear;
    private final String name;

    public AdvancedFboTextureAttachment(int attachmentType, int format, int texelFormat, int dataType, int width, int height, int mipmapLevels, boolean linear, @Nullable String name) {
        this.attachmentType = attachmentType;
        this.format = format;
        this.texelFormat = texelFormat;
        this.dataType = dataType;
        this.width = width;
        this.height = height;
        this.mipmapLevels = mipmapLevels;
        this.linear = linear;
        this.name = name;
    }

    @Override
    public void create() {
        this.bindAttachment();
        this.m_117960_(this.linear, this.mipmapLevels > 1);
        GlStateManager._texParameter((int)3553, (int)33085, (int)this.mipmapLevels);
        GlStateManager._texParameter((int)3553, (int)33082, (int)0);
        GlStateManager._texParameter((int)3553, (int)33083, (int)this.mipmapLevels);
        GlStateManager._texParameter((int)3553, (int)34049, (float)0.0f);
        GlStateManager._texParameter((int)3553, (int)10242, (int)33071);
        GlStateManager._texParameter((int)3553, (int)10243, (int)33071);
        for (int i = 0; i <= this.mipmapLevels; ++i) {
            GlStateManager._texImage2D((int)3553, (int)i, (int)this.format, (int)(this.width >> i), (int)(this.height >> i), (int)0, (int)this.texelFormat, (int)this.dataType, null);
        }
        this.unbindAttachment();
    }

    @Override
    public void attach(int attachment) {
        Validate.isTrue((this.attachmentType < 36096 || attachment == 0 ? 1 : 0) != 0, (String)"Only one depth buffer attachment is supported.", (Object[])new Object[0]);
        GlStateManager._glFramebufferTexture2D((int)36160, (int)(this.attachmentType + attachment), (int)3553, (int)this.m_117963_(), (int)0);
    }

    @Override
    public AdvancedFboTextureAttachment clone() {
        return new AdvancedFboTextureAttachment(this.attachmentType, this.format, this.texelFormat, this.dataType, this.width, this.height, this.mipmapLevels, this.linear, this.name);
    }

    @Override
    public void bindAttachment() {
        this.m_117966_();
    }

    @Override
    public void unbindAttachment() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> RenderSystem.bindTexture((int)0));
        } else {
            RenderSystem.bindTexture((int)0);
        }
    }

    @Override
    public int getAttachmentType() {
        return this.attachmentType;
    }

    @Override
    public int getFormat() {
        return this.format;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getLevels() {
        return this.mipmapLevels;
    }

    @Override
    public boolean canSample() {
        return true;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    public void free() {
        this.m_117964_();
    }

    public void m_6704_(ResourceManager manager) {
    }
}

