/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.framebuffer;

import com.mojang.blaze3d.platform.GlStateManager;
import foundry.veil.api.client.render.framebuffer.AdvancedFboTextureAttachment;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class AdvancedFboMutableTextureAttachment
extends AdvancedFboTextureAttachment {
    private int textureTarget;
    private int textureId;
    private int width;
    private int height;

    public AdvancedFboMutableTextureAttachment(int textureId, int textureTarget, int attachmentType, int width, int height) {
        super(attachmentType, 0, 0, 0, 0, 0, 0, false, null);
        this.setTexture(textureTarget, textureId, width, height);
    }

    @Override
    public void attach(int attachment) {
        int attachmentType = this.getAttachmentType();
        Validate.isTrue((attachmentType < 36096 || attachment == 0 ? 1 : 0) != 0, (String)"Only one depth buffer attachment is supported.", (Object[])new Object[0]);
        GlStateManager._glFramebufferTexture2D((int)36160, (int)(attachmentType + attachment), (int)this.textureTarget, (int)this.m_117963_(), (int)0);
    }

    @Override
    public void create() {
    }

    @Override
    public AdvancedFboMutableTextureAttachment clone() {
        return new AdvancedFboMutableTextureAttachment(this.textureId, this.textureTarget, this.getAttachmentType(), this.getWidth(), this.getHeight());
    }

    public void m_117964_() {
    }

    public int m_117963_() {
        return this.textureId;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public boolean setTexture(int textureTarget, int textureId, int width, int height) {
        if (this.textureTarget == textureTarget && this.textureId == textureId && this.width == width && this.height == height) {
            return false;
        }
        this.textureTarget = textureTarget;
        this.textureId = textureId;
        this.width = width;
        this.height = height;
        return true;
    }
}

