/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil;

import com.mojang.blaze3d.platform.InputConstants;
import foundry.veil.Veil;
import foundry.veil.api.client.editor.EditorManager;
import foundry.veil.api.client.registry.LightTypeRegistry;
import foundry.veil.api.client.registry.PostPipelineStageRegistry;
import foundry.veil.api.client.registry.RenderTypeLayerRegistry;
import foundry.veil.api.client.registry.RenderTypeStageRegistry;
import foundry.veil.api.client.registry.VeilResourceEditorRegistry;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.deferred.VeilDeferredRenderer;
import foundry.veil.api.event.VeilRenderLevelStageEvent;
import foundry.veil.api.quasar.data.ParticleModuleTypeRegistry;
import foundry.veil.api.quasar.registry.EmitterShapeRegistry;
import foundry.veil.api.quasar.registry.RenderStyleRegistry;
import foundry.veil.impl.client.editor.DeferredEditor;
import foundry.veil.impl.client.editor.DemoEditor;
import foundry.veil.impl.client.editor.DeviceInfoViewer;
import foundry.veil.impl.client.editor.FramebufferEditor;
import foundry.veil.impl.client.editor.LightEditor;
import foundry.veil.impl.client.editor.OpenCLEditor;
import foundry.veil.impl.client.editor.PostEditor;
import foundry.veil.impl.client.editor.ResourceManagerEditor;
import foundry.veil.impl.client.editor.TextureEditor;
import foundry.veil.impl.client.imgui.VeilImGuiImpl;
import foundry.veil.impl.resource.VeilResourceManagerImpl;
import foundry.veil.platform.VeilClientPlatform;
import foundry.veil.platform.VeilEventPlatform;
import java.util.ServiceLoader;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL11C;

public class VeilClient {
    private static final VeilClientPlatform PLATFORM = ServiceLoader.load(VeilClientPlatform.class).findFirst().orElseThrow(() -> new RuntimeException("Veil expected client platform implementation"));
    private static final VeilResourceManagerImpl RESOURCE_MANAGER = new VeilResourceManagerImpl();
    public static final KeyMapping EDITOR_KEY = new KeyMapping("key.veil.editor", InputConstants.Type.KEYSYM, 295, "key.categories.veil");

    @ApiStatus.Internal
    public static void init() {
        VeilImGuiImpl.setImGuiPath();
        VeilEventPlatform.INSTANCE.onFreeNativeResources(() -> {
            VeilRenderSystem.close();
            RESOURCE_MANAGER.free();
        });
        VeilEventPlatform.INSTANCE.onVeilRendererAvailable(renderer -> {
            if (Veil.SODIUM) {
                SystemToast.m_94855_((ToastComponent)Minecraft.m_91087_().m_91300_(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.PERIODIC_NOTIFICATION, (Component)VeilDeferredRenderer.UNSUPPORTED_TITLE, (Component)VeilDeferredRenderer.UNSUPPORTED_SODIUM_DESC);
            }
            RESOURCE_MANAGER.addVeilLoaders(renderer);
            if (VeilRenderer.hasImGui()) {
                EditorManager editorManager = renderer.getEditorManager();
                editorManager.add(new DemoEditor());
                editorManager.add(new PostEditor());
                editorManager.add(new TextureEditor());
                editorManager.add(new OpenCLEditor());
                editorManager.add(new DeviceInfoViewer());
                editorManager.add(new DeferredEditor());
                editorManager.add(new LightEditor());
                editorManager.add(new FramebufferEditor());
                editorManager.add(new ResourceManagerEditor());
            }
            GL11C.glEnable((int)34383);
        });
        VeilEventPlatform.INSTANCE.onVeilRegisterFixedBuffers(registry -> registry.registerFixedBuffer(VeilRenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS, RenderType.m_110469_()));
        RenderTypeStageRegistry.addGenericStage(renderType -> true, new RenderStateShard("veil:deferred", () -> VeilRenderSystem.renderer().getDeferredRenderer().setup(), () -> VeilRenderSystem.renderer().getDeferredRenderer().clear()){});
        PostPipelineStageRegistry.bootstrap();
        LightTypeRegistry.bootstrap();
        RenderTypeLayerRegistry.bootstrap();
        VeilResourceEditorRegistry.bootstrap();
        EmitterShapeRegistry.bootstrap();
        RenderStyleRegistry.bootstrap();
        ParticleModuleTypeRegistry.bootstrap();
    }

    @ApiStatus.Internal
    public static void initRenderer() {
        VeilRenderSystem.init();
    }

    @ApiStatus.Internal
    public static void tickClient(float partialTick) {
    }

    public static VeilClientPlatform clientPlatform() {
        return PLATFORM;
    }

    public static VeilResourceManagerImpl resourceManager() {
        return RESOURCE_MANAGER;
    }
}

