/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.graveyard.constraint;

import foundry.veil.api.client.graveyard.constraint.Constraint;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedBone;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedSkeleton;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedSkeletonParent;
import foundry.veil.api.client.util.DebugRenderHelper;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class InverseKinematicsConstraint
implements Constraint {
    private final List<InterpolatedBone> bones;
    private final List<Vector3f> points;
    private final boolean[] jointDirections;
    private final FloatList segmentLengths;
    private final Vector3f endPlacement;
    private final Vector3f target;
    private final Vector3f poleTarget;
    private final InverseKinematicDirection forwardDirection;
    private final float minimumAcceptableDistance;

    public InverseKinematicsConstraint(InterpolatedBone chainEnd, int depth, float endX, float endY, float endZ, float minimumAcceptableDistance) {
        this(InverseKinematicDirection.NEGATIVE_Y, chainEnd, depth, endX, endY, endZ, minimumAcceptableDistance);
    }

    public InverseKinematicsConstraint(InverseKinematicDirection forwardDirection, InterpolatedBone chainEnd, int depth, float endX, float endY, float endZ, float minimumAcceptableDistance) {
        int i;
        this.forwardDirection = forwardDirection;
        this.minimumAcceptableDistance = minimumAcceptableDistance;
        this.bones = new ArrayList<InterpolatedBone>(depth);
        this.points = new ArrayList<Vector3f>(depth + 1);
        this.segmentLengths = new FloatArrayList(depth);
        this.endPlacement = new Vector3f(endX, endY, endZ);
        this.target = new Vector3f();
        this.poleTarget = new Vector3f();
        for (i = chainEnd.parentChain.size() + 1 - depth; i < chainEnd.parentChain.size(); ++i) {
            this.bones.add(chainEnd.parentChain.get(i));
        }
        this.bones.add(chainEnd);
        for (i = 0; i < this.bones.size() + 1; ++i) {
            this.points.add(new Vector3f());
        }
        for (i = 0; i < this.points.size() - 1; ++i) {
            this.segmentLengths.add(this.points.get(i + 1).distance((Vector3fc)this.points.get(i)));
        }
        this.updatePointLocations();
        this.jointDirections = new boolean[this.points.size()];
    }

    @Override
    public void apply() {
        this.updatePointLocations();
        this.updateJointDirections();
        Vector3f origin = new Vector3f((Vector3fc)this.points.get(0));
        Vector3f planeNormal = new Vector3f((Vector3fc)this.target);
        planeNormal.sub((Vector3fc)origin);
        Vector3f pn2 = new Vector3f((Vector3fc)this.poleTarget);
        pn2.sub((Vector3fc)origin);
        planeNormal.cross((Vector3fc)pn2);
        planeNormal.normalize();
        for (int iteration = 0; iteration < 32; ++iteration) {
            boolean startingFromTarget = iteration % 2 == 0;
            Collections.reverse(this.points);
            Collections.reverse(this.segmentLengths);
            Vector3f currentTarget = startingFromTarget ? this.target : origin;
            this.points.get(0).set(currentTarget.x(), currentTarget.y(), currentTarget.z());
            this.correctPointLengths();
            this.projectPointsOntoPlane((Vector3fc)planeNormal);
            this.correctJointDirections();
        }
        this.updateBoneTransforms();
    }

    private void correctPointLengths() {
        for (int i = 1; i < this.points.size(); ++i) {
            Vector3f point = this.points.get(i);
            Vector3f previousPoint = this.points.get(i - 1);
            Vector3f dir = new Vector3f((Vector3fc)point);
            dir.sub((Vector3fc)previousPoint);
            dir.normalize();
            dir.mul(this.segmentLengths.getFloat(i - 1));
            point.set(previousPoint.x() + dir.x(), previousPoint.y() + dir.y(), previousPoint.z() + dir.z());
        }
    }

    private void projectPointsOntoPlane(Vector3fc planeNormal) {
        for (Vector3f point : this.points) {
            Vector3f v = new Vector3f((Vector3fc)point);
            v.sub((Vector3fc)this.poleTarget);
            float dist = v.dot(planeNormal);
            point.set(point.x() - dist * planeNormal.x(), point.y() - dist * planeNormal.y(), point.z() - dist * planeNormal.z());
        }
    }

    private void correctJointDirections() {
        for (int i = 1; i < this.points.size() - 1; ++i) {
            Vector3f nextPoint;
            Vector3f prevPoint;
            Vector3f point = this.points.get(i);
            boolean direction = this.calculateJointDirection((Vector3fc)point, (Vector3fc)(prevPoint = this.points.get(i - 1)), (Vector3fc)(nextPoint = this.points.get(i + 1)), (Vector3fc)this.poleTarget);
            if (direction == this.jointDirections[i]) continue;
            Vector3f projectedPoint = InverseKinematicsConstraint.projectPointOntoLine((Vector3fc)point, (Vector3fc)prevPoint, (Vector3fc)nextPoint);
            point.set(class_3532.method_16439((float)2.0f, (float)point.x(), (float)projectedPoint.x()), class_3532.method_16439((float)2.0f, (float)point.y(), (float)projectedPoint.y()), class_3532.method_16439((float)2.0f, (float)point.z(), (float)projectedPoint.z()));
        }
    }

    private void updateJointDirections() {
        Vector3f polePoint = new Vector3f((Vector3fc)this.points.get(0));
        polePoint.lerp((Vector3fc)this.points.get(this.points.size() - 1), 0.5f);
        Vector3f poleDirection = new Vector3f(0.0f, 0.0f, 0.0f);
        switch (this.forwardDirection) {
            case NEGATIVE_X: {
                poleDirection.add(0.0f, 8.0f, 0.0f);
                break;
            }
            case POSITIVE_X: {
                poleDirection.add(0.0f, -8.0f, 0.0f);
                break;
            }
            case NEGATIVE_Y: {
                poleDirection.add(0.0f, 0.0f, 8.0f);
                break;
            }
            case POSITIVE_Y: {
                poleDirection.add(0.0f, 0.0f, -8.0f);
                break;
            }
            case NEGATIVE_Z: {
                poleDirection.add(8.0f, 0.0f, 0.0f);
                break;
            }
            case POSITIVE_Z: {
                poleDirection.add(-8.0f, 0.0f, 0.0f);
            }
        }
        InterpolatedBone parent = this.bones.get((int)0).parent;
        if (parent != null) {
            Quaternionf rotation = new Quaternionf();
            for (InterpolatedBone bone : parent.parentChain) {
                rotation.mul((Quaternionfc)bone.rotation);
            }
            rotation.mul((Quaternionfc)parent.rotation);
            poleDirection = rotation.transform(poleDirection);
        }
        polePoint.add((Vector3fc)poleDirection);
        for (int i = 1; i < this.points.size() - 1; ++i) {
            Vector3f point = this.points.get(i);
            Vector3f prevPoint = this.points.get(i - 1);
            Vector3f nextPoint = this.points.get(i + 1);
            this.jointDirections[i] = this.calculateJointDirection((Vector3fc)point, (Vector3fc)prevPoint, (Vector3fc)nextPoint, (Vector3fc)polePoint);
        }
    }

    private boolean calculateJointDirection(Vector3fc point, Vector3fc prevPoint, Vector3fc nextPoint, Vector3fc polePoint) {
        Vector3f projectedPoint = InverseKinematicsConstraint.projectPointOntoLine(point, prevPoint, nextPoint);
        Vector3f projectedPole = InverseKinematicsConstraint.projectPointOntoLine(polePoint, prevPoint, nextPoint);
        Vector3f pointDirection = new Vector3f((Vector3fc)projectedPoint);
        pointDirection.sub(point);
        Vector3f poleDirection = new Vector3f((Vector3fc)projectedPole);
        poleDirection.sub(polePoint);
        float dot = pointDirection.dot((Vector3fc)poleDirection);
        return dot > 0.0f;
    }

    private void updatePointLocations() {
        class_4587 stack = new class_4587();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            stack.method_22903();
            InterpolatedBone bone = this.bones.get(i);
            bone.getModelSpaceTransformMatrix(stack, 1.0f);
            Vector4f point4 = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
            stack.method_23760().method_23761().transform(point4);
            this.points.get(i).set(point4.x(), point4.y(), point4.z());
            stack.method_22909();
        }
        stack.method_22903();
        InterpolatedBone bone = this.bones.get(this.bones.size() - 1);
        bone.getModelSpaceTransformMatrix(stack, 1.0f);
        Vector4f point4 = new Vector4f(this.endPlacement.x(), this.endPlacement.y(), this.endPlacement.z(), 1.0f);
        stack.method_23760().method_23761().transform(point4);
        this.points.get(this.points.size() - 1).set(point4.x(), point4.y(), point4.z());
        stack.method_22909();
        for (int i = 0; i < this.segmentLengths.size(); ++i) {
            this.segmentLengths.set(i, this.points.get(i).distance((Vector3fc)this.points.get(i + 1)));
        }
    }

    private void updateBoneTransforms() {
        Vector3f perpendicular = new Vector3f((Vector3fc)this.points.get(this.points.size() - 1));
        perpendicular.cross((Vector3fc)this.poleTarget);
        perpendicular.normalize();
        perpendicular.mul(-1.0f);
        for (int i = 0; i < this.bones.size(); ++i) {
            InterpolatedBone bone = this.bones.get(i);
            Vector3f point = this.points.get(i);
            Vector3f nextPoint = this.points.get(i + 1);
            Vector3f forward = new Vector3f((Vector3fc)nextPoint);
            forward.sub((Vector3fc)point);
            forward.normalize();
            bone.setGlobalSpaceRotation(new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, -1.0f, 0.0f), (Vector3fc)forward));
        }
    }

    @Override
    public void renderDebugInfo(InterpolatedSkeleton skeleton, InterpolatedSkeletonParent parent, float pPartialTicks, class_4587 poseStack, class_4597 pBuffer) {
        Vector3f point;
        class_4588 vertexconsumer = pBuffer.getBuffer((class_1921)class_1921.field_21695);
        Vector3f x = new Vector3f((Vector3fc)this.points.get(this.points.size() - 1));
        x.cross((Vector3fc)this.poleTarget);
        x.normalize();
        x.mul(-1.0f);
        for (int i = 0; i < this.points.size(); ++i) {
            float color1 = (float)i / (float)this.points.size();
            point = this.points.get(i);
            DebugRenderHelper.renderSphere(poseStack, vertexconsumer, 16, 0.2f, point.x(), point.y(), point.z(), color1, i == 0 ? 0.0f : color1, color1, 1.0f);
            if (i < 1) continue;
            float color0 = (float)(i - 1) / (float)this.points.size();
            Vector3f pPoint = this.points.get(i - 1);
            DebugRenderHelper.renderLine(poseStack, vertexconsumer, point.x(), point.y(), point.z(), pPoint.x(), pPoint.y(), pPoint.z(), color1, color1, color1, 1.0f, color0, color0, color0, 1.0f);
        }
        point = this.target;
        DebugRenderHelper.renderSphere(poseStack, vertexconsumer, 16, 0.4f, point.x(), point.y(), point.z(), 1.0f, 0.0f, 0.0f, 1.0f);
        point = this.poleTarget;
        DebugRenderHelper.renderSphere(poseStack, vertexconsumer, 16, 0.4f, point.x(), point.y(), point.z(), 0.0f, 1.0f, 0.0f, 1.0f);
    }

    private static Vector3f projectPointOntoLine(Vector3fc point, Vector3fc lineStart, Vector3fc lineEnd) {
        Vector3f lineDirection = lineEnd.sub(lineStart, new Vector3f());
        Vector3f fromLineStartToPoint = point.sub(lineStart, new Vector3f());
        float projectionLength = fromLineStartToPoint.dot((Vector3fc)lineDirection) / lineDirection.lengthSquared();
        return lineDirection.mul(projectionLength).add(lineStart);
    }

    public static enum InverseKinematicDirection {
        POSITIVE_X(new Vector3f(1.0f, 0.0f, 0.0f)),
        POSITIVE_Y(new Vector3f(0.0f, 1.0f, 0.0f)),
        POSITIVE_Z(new Vector3f(0.0f, 0.0f, 1.0f)),
        NEGATIVE_X(new Vector3f(-1.0f, 0.0f, 0.0f)),
        NEGATIVE_Y(new Vector3f(0.0f, -1.0f, 0.0f)),
        NEGATIVE_Z(new Vector3f(0.0f, 0.0f, -1.0f));

        private final Vector3f direction;

        private InverseKinematicDirection(Vector3f direction) {
            this.direction = direction;
        }
    }
}

