/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.editor;

import foundry.veil.Veil;
import foundry.veil.api.client.editor.Editor;
import foundry.veil.api.client.editor.EditorFontManager;
import foundry.veil.api.client.registry.VeilResourceEditorRegistry;
import foundry.veil.api.resource.editor.ResourceFileEditor;
import foundry.veil.api.util.CompositeReloadListener;
import imgui.ImFont;
import imgui.ImGui;
import imgui.type.ImBoolean;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_3695;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class EditorManager
implements class_3302 {
    public static final class_2960 DEFAULT_FONT = Veil.veilPath("jetbrains_mono");
    private final Map<Editor, ImBoolean> editors = new TreeMap<Editor, ImBoolean>(Comparator.comparing(editor -> editor.getClass().getSimpleName()));
    private final EditorFontManager fonts = new EditorFontManager();
    private boolean enabled = false;

    @ApiStatus.Internal
    public EditorManager(class_3304 resourceManager) {
        resourceManager.method_14477((class_3302)this);
    }

    public ImFont getFont(class_2960 name, boolean bold, boolean italic) {
        return this.fonts.getFont(name, bold, italic);
    }

    public ImFont getFont(boolean bold, boolean italic) {
        return this.getFont(DEFAULT_FONT, bold, italic);
    }

    @ApiStatus.Internal
    public void render() {
        if (!this.enabled) {
            return;
        }
        if (ImGui.beginMainMenuBar()) {
            Editor editor;
            ImFont font = ImGui.getFont();
            float dingleWidth = font.calcTextSizeAX((float)ImGui.getFontSize(), Float.MAX_VALUE, 0.0f, " Veil ") + 4.0f;
            float dingleHeight = ImGui.getTextLineHeightWithSpacing() + 2.0f;
            ImGui.getWindowDrawList().addRectFilled(0.0f, 0.0f, dingleWidth, dingleHeight, ImGui.getColorU32((int)8));
            ImGui.text((String)"Veil ");
            for (Map.Entry<Editor, ImBoolean> entry : this.editors.entrySet()) {
                editor = entry.getKey();
                class_2561 group = editor.getGroup();
                if (group == null) {
                    if (Veil.platform().isDevelopmentEnvironment()) {
                        Veil.LOGGER.error("Editor '{}' should return Editor#DEFAULT_GROUP instead of null", editor.getClass());
                    }
                    group = Editor.DEFAULT_GROUP;
                }
                if (!ImGui.beginMenu((String)group.getString())) continue;
                ImBoolean enabled = entry.getValue();
                ImGui.beginDisabled((!editor.isEnabled() ? 1 : 0) != 0);
                if (ImGui.menuItem((String)editor.getDisplayName().getString(), null, (boolean)enabled.get())) {
                    if (!enabled.get()) {
                        this.show(editor);
                    } else {
                        this.hide(editor);
                    }
                }
                ImGui.endDisabled();
                ImGui.endMenu();
            }
            for (Map.Entry<Editor, ImBoolean> entry : this.editors.entrySet()) {
                editor = entry.getKey();
                if (!entry.getValue().get() || !editor.isMenuBarEnabled()) continue;
                ImGui.separator();
                ImGui.textColored((int)-5592406, (String)editor.getDisplayName().getString());
                editor.renderMenuBar();
            }
            ImGui.endMainMenuBar();
        }
        for (Map.Entry<Editor, ImBoolean> entry : this.editors.entrySet()) {
            Editor editor = entry.getKey();
            ImBoolean enabled = entry.getValue();
            if (!editor.isEnabled()) {
                enabled.set(false);
            }
            if (!enabled.get()) continue;
            editor.render();
        }
        for (ResourceFileEditor editor : VeilResourceEditorRegistry.REGISTRY) {
            editor.render();
        }
    }

    @ApiStatus.Internal
    public void renderLast() {
        if (!this.enabled) {
            return;
        }
        for (Map.Entry<Editor, ImBoolean> entry : this.editors.entrySet()) {
            Editor editor = entry.getKey();
            ImBoolean enabled = entry.getValue();
            if (!enabled.get()) continue;
            editor.renderLast();
        }
    }

    public void show(Editor editor) {
        ImBoolean enabled = this.editors.get(editor);
        if (enabled != null && !enabled.get()) {
            editor.onShow();
            enabled.set(true);
        }
    }

    public void hide(Editor editor) {
        ImBoolean enabled = this.editors.get(editor);
        if (enabled != null && enabled.get()) {
            editor.onHide();
            enabled.set(false);
        }
    }

    public boolean isVisible(Editor editor) {
        ImBoolean visible = this.editors.get(editor);
        return visible != null && visible.get();
    }

    public synchronized void add(Editor editor) {
        this.editors.computeIfAbsent(editor, unused -> new ImBoolean());
    }

    public synchronized void remove(Editor editor) {
        this.hide(editor);
        this.editors.remove(editor);
    }

    public void toggle() {
        this.enabled = !this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @NotNull
    public CompletableFuture<Void> method_25931(@NotNull class_3302.class_4045 preparationBarrier, @NotNull class_3300 resourceManager, @NotNull class_3695 prepareProfiler, @NotNull class_3695 applyProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        class_3302 listener;
        ArrayList<class_3302> listeners = new ArrayList<class_3302>(this.editors.size());
        listeners.add(this.fonts);
        for (Editor editor : this.editors.keySet()) {
            if (!(editor instanceof class_3302)) continue;
            listener = (class_3302)editor;
            listeners.add(listener);
        }
        for (ResourceFileEditor resourceFileEditor : VeilResourceEditorRegistry.REGISTRY) {
            if (!(resourceFileEditor instanceof class_3302)) continue;
            listener = (class_3302)resourceFileEditor;
            listeners.add(listener);
        }
        class_3302 listener2 = CompositeReloadListener.of((class_3302[])listeners.toArray(class_3302[]::new));
        return listener2.method_25931(preparationBarrier, resourceManager, prepareProfiler, applyProfiler, backgroundExecutor, gameExecutor);
    }
}

