/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.deferred;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class DeferredVertexConsumer
implements VertexConsumer {
    private final VertexConsumer delegate;
    private boolean verticalNormal;

    public DeferredVertexConsumer(VertexConsumer delegate) {
        this.delegate = delegate;
    }

    public VertexConsumer vertex(double pX, double pY, double pZ) {
        this.delegate.vertex(pX, pY, pZ);
        return this;
    }

    public VertexConsumer color(int pRed, int pGreen, int pBlue, int pAlpha) {
        this.delegate.color(pRed, pGreen, pBlue, pAlpha);
        return this;
    }

    public VertexConsumer uv(float pU, float pV) {
        this.delegate.uv(pU, pV);
        return this;
    }

    public VertexConsumer overlayCoords(int pU, int pV) {
        this.delegate.overlayCoords(pU, pV);
        return this;
    }

    public VertexConsumer uv2(int pU, int pV) {
        this.delegate.uv2(pU, pV);
        return this;
    }

    public VertexConsumer normal(float pX, float pY, float pZ) {
        if (this.verticalNormal) {
            this.delegate.normal(0.0f, 1.0f, 0.0f);
        } else {
            this.delegate.normal(pX, pY, pZ);
        }
        return this;
    }

    public void endVertex() {
        this.delegate.endVertex();
    }

    public void defaultColor(int pDefaultR, int pDefaultG, int pDefaultB, int pDefaultA) {
        this.delegate.defaultColor(pDefaultR, pDefaultG, pDefaultB, pDefaultA);
    }

    public void unsetDefaultColor() {
        this.delegate.unsetDefaultColor();
    }

    public void putBulkData(PoseStack.Pose pPoseEntry, BakedQuad pQuad, float[] pColorMuls, float pRed, float pGreen, float pBlue, int[] pCombinedLights, int pCombinedOverlay, boolean pMulColor) {
        this.verticalNormal = !pQuad.isShade();
        super.putBulkData(pPoseEntry, pQuad, pColorMuls, pRed, pGreen, pBlue, pCombinedLights, pCombinedOverlay, pMulColor);
        this.verticalNormal = false;
    }
}

