/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.quasar.data.QuasarParticles;
import foundry.veil.api.quasar.data.module.ParticleModuleData;
import foundry.veil.api.quasar.particle.RenderStyle;
import foundry.veil.api.quasar.particle.SpriteData;
import foundry.veil.api.quasar.registry.RenderStyleRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public record QuasarParticleData(boolean shouldCollide, boolean faceVelocity, float velocityStretchFactor, List<Holder<ParticleModuleData>> initModules, List<Holder<ParticleModuleData>> updateModules, List<Holder<ParticleModuleData>> collisionModules, List<Holder<ParticleModuleData>> forceModules, List<Holder<ParticleModuleData>> renderModules, @Nullable SpriteData spriteData, boolean additive, RenderStyle renderStyle) {
    public static final Codec<QuasarParticleData> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("should_collide", (Object)true).forGetter(QuasarParticleData::shouldCollide), (App)Codec.BOOL.optionalFieldOf("face_velocity", (Object)false).forGetter(QuasarParticleData::faceVelocity), (App)Codec.FLOAT.optionalFieldOf("velocity_stretch_factor", (Object)Float.valueOf(0.0f)).forGetter(QuasarParticleData::velocityStretchFactor), (App)ParticleModuleData.INIT_CODEC.listOf().optionalFieldOf("init_modules", Collections.emptyList()).forGetter(QuasarParticleData::initModules), (App)ParticleModuleData.UPDATE_CODEC.listOf().optionalFieldOf("update_modules", Collections.emptyList()).forGetter(QuasarParticleData::updateModules), (App)ParticleModuleData.UPDATE_CODEC.listOf().optionalFieldOf("collision_modules", Collections.emptyList()).forGetter(QuasarParticleData::collisionModules), (App)ParticleModuleData.UPDATE_CODEC.listOf().optionalFieldOf("forces", Collections.emptyList()).forGetter(QuasarParticleData::forceModules), (App)ParticleModuleData.RENDER_CODEC.listOf().optionalFieldOf("render_modules", Collections.emptyList()).forGetter(QuasarParticleData::renderModules), (App)SpriteData.CODEC.optionalFieldOf("sprite_data").forGetter(data -> Optional.ofNullable(data.spriteData())), (App)Codec.BOOL.optionalFieldOf("additive", (Object)false).forGetter(QuasarParticleData::additive), (App)RenderStyle.CODEC.optionalFieldOf("render_style", (Object)RenderStyleRegistry.BILLBOARD.get()).forGetter(QuasarParticleData::renderStyle)).apply((Applicative)instance, (shouldCollide, faceVelocity, velocityStretchFactor, initModules, updateModules, collisionModules, forceModules, renderModules, spriteData, additive, renderStyle) -> new QuasarParticleData((boolean)shouldCollide, (boolean)faceVelocity, velocityStretchFactor.floatValue(), (List<Holder<ParticleModuleData>>)initModules, (List<Holder<ParticleModuleData>>)updateModules, (List<Holder<ParticleModuleData>>)collisionModules, (List<Holder<ParticleModuleData>>)forceModules, (List<Holder<ParticleModuleData>>)renderModules, spriteData.orElse(null), (boolean)additive, (RenderStyle)renderStyle)));
    public static final Codec<Holder<QuasarParticleData>> CODEC = RegistryFileCodec.create(QuasarParticles.PARTICLE_DATA, DIRECT_CODEC);

    public QuasarParticleData(boolean shouldCollide, boolean faceVelocity, float velocityStretchFactor, List<Holder<ParticleModuleData>> initModules, List<Holder<ParticleModuleData>> updateModules, List<Holder<ParticleModuleData>> collisionModules, List<Holder<ParticleModuleData>> forceModules, List<Holder<ParticleModuleData>> renderModules, @Nullable SpriteData spriteData, boolean additive, RenderStyle renderStyle) {
        this.shouldCollide = shouldCollide;
        this.faceVelocity = faceVelocity;
        this.velocityStretchFactor = velocityStretchFactor;
        this.initModules = Collections.unmodifiableList(initModules);
        this.updateModules = Collections.unmodifiableList(updateModules);
        this.collisionModules = Collections.unmodifiableList(collisionModules);
        this.forceModules = Collections.unmodifiableList(forceModules);
        this.renderModules = Collections.unmodifiableList(renderModules);
        this.spriteData = spriteData;
        this.additive = additive;
        this.renderStyle = renderStyle;
    }

    public Stream<Holder<ParticleModuleData>> allModules() {
        Stream.Builder<Holder<ParticleModuleData>> builder = Stream.builder();
        for (Holder<ParticleModuleData> initModule : this.initModules) {
            builder.add(initModule);
        }
        for (Holder<ParticleModuleData> initModule : this.updateModules) {
            builder.add(initModule);
        }
        for (Holder<ParticleModuleData> initModule : this.collisionModules) {
            builder.add(initModule);
        }
        for (Holder<ParticleModuleData> initModule : this.forceModules) {
            builder.add(initModule);
        }
        for (Holder<ParticleModuleData> initModule : this.renderModules) {
            builder.add(initModule);
        }
        return builder.build();
    }

    @Nullable
    public ResourceLocation getRegistryId() {
        return QuasarParticles.registryAccess().registry(QuasarParticles.PARTICLE_DATA).map(registry -> registry.getKey((Object)this)).orElse(null);
    }
}

