/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.processor;

import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import foundry.veil.api.client.render.shader.processor.ShaderMultiProcessor;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public interface ShaderPreProcessor {
    public static final ShaderPreProcessor NOOP = (ctx, source) -> source;
    public static final Pattern UNIFORM_PATTERN = Pattern.compile(".*uniform\\s+(?<type>\\w+)\\W(?<name>\\w*)");

    default public void prepare() {
    }

    public String modify(Context var1, String var2) throws IOException;

    public static ShaderPreProcessor allOf(ShaderPreProcessor ... processors) {
        return ShaderPreProcessor.allOf(Arrays.asList(processors));
    }

    public static ShaderPreProcessor allOf(Collection<ShaderPreProcessor> processors) {
        ArrayList<ShaderPreProcessor> list = new ArrayList<ShaderPreProcessor>(processors.size());
        for (ShaderPreProcessor processor : processors) {
            if (processor instanceof ShaderMultiProcessor) {
                ShaderMultiProcessor multiProcessor = (ShaderMultiProcessor)processor;
                list.addAll(Arrays.asList(multiProcessor.processors()));
                continue;
            }
            if (processor == NOOP) continue;
            list.add(processor);
        }
        if (list.isEmpty()) {
            return NOOP;
        }
        if (list.size() == 1) {
            return (ShaderPreProcessor)list.get(0);
        }
        return new ShaderMultiProcessor(list.toArray(new ShaderPreProcessor[0]));
    }

    public static interface Context {
        public String modify(@Nullable ResourceLocation var1, String var2) throws IOException;

        public void addUniformBinding(String var1, int var2);

        public void addDefinitionDependency(String var1);

        public void addInclude(ResourceLocation var1);

        public Set<ResourceLocation> includes();

        @Nullable
        public ResourceLocation name();

        public boolean isSourceFile();

        @Nullable
        public ProgramDefinition definition();

        @Nullable
        public ShaderPreDefinitions preDefinitions();
    }
}

